/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.concurrent.jobs;

import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.strategy.Strategy;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.concurrent.jobs.TrainingJob;
import org.encog.neural.networks.training.propagation.resilient.ResilientPropagation;

public class RPROPJob
extends TrainingJob {
    private double initialUpdate = 0.1;
    private double maxStep = 50.0;

    public RPROPJob(BasicNetwork network, MLDataSet training, boolean loadToMemory) {
        super(network, training, loadToMemory);
    }

    @Override
    public final void createTrainer(boolean singleThreaded) {
        ResilientPropagation train = new ResilientPropagation(this.getNetwork(), this.getTraining(), this.getInitialUpdate(), this.getMaxStep());
        if (singleThreaded) {
            train.setThreadCount(1);
        } else {
            train.setThreadCount(0);
        }
        for (Strategy strategy : this.getStrategies()) {
            train.addStrategy(strategy);
        }
        this.setTrain(train);
    }

    public final double getInitialUpdate() {
        return this.initialUpdate;
    }

    public final double getMaxStep() {
        return this.maxStep;
    }

    public final void setInitialUpdate(double initialUpdate) {
        this.initialUpdate = initialUpdate;
    }

    public final void setMaxStep(double maxStep) {
        this.maxStep = maxStep;
    }
}

