/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.som;

import org.encog.mathutil.matrices.Matrix;
import org.encog.ml.BasicML;
import org.encog.ml.MLClassification;
import org.encog.ml.MLError;
import org.encog.ml.MLResettable;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.som.training.basic.BestMatchingUnit;
import org.encog.util.EngineArray;

public class SOM
extends BasicML
implements MLClassification,
MLResettable,
MLError {
    private static final long serialVersionUID = 1L;
    public static final double VERYSMALL = 1.0E-30;
    private Matrix weights;

    public SOM() {
    }

    public SOM(int inputCount, int outputCount) {
        this.weights = new Matrix(outputCount, inputCount);
    }

    @Override
    public final double calculateError(MLDataSet data) {
        BestMatchingUnit bmu = new BestMatchingUnit(this);
        bmu.reset();
        for (MLDataPair pair : data) {
            MLData input = pair.getInput();
            bmu.calculateBMU(input);
        }
        return bmu.getWorstDistance() / 100.0;
    }

    @Override
    public final int classify(MLData input) {
        if (input.size() > this.getInputCount()) {
            throw new NeuralNetworkError("Can't classify SOM with input size of " + this.getInputCount() + " with input data of count " + input.size());
        }
        double[][] m = this.weights.getData();
        double[] inputData = input.getData();
        double minDist = Double.POSITIVE_INFINITY;
        int result = -1;
        for (int i = 0; i < this.getOutputCount(); ++i) {
            double dist = EngineArray.euclideanDistance(inputData, m[i]);
            if (!(dist < minDist)) continue;
            minDist = dist;
            result = i;
        }
        return result;
    }

    @Override
    public final int getInputCount() {
        return this.weights.getCols();
    }

    @Override
    public final int getOutputCount() {
        return this.weights.getRows();
    }

    public final Matrix getWeights() {
        return this.weights;
    }

    @Override
    public final void reset() {
        this.weights.randomize(-1.0, 1.0);
    }

    @Override
    public final void reset(int seed) {
        this.reset();
    }

    public final void setWeights(Matrix weights) {
        this.weights = weights;
    }

    @Override
    public final void updateProperties() {
    }

    public final int winner(MLData input) {
        return this.classify(input);
    }
}

