/*
 * Encog(tm) Core v3.2 - Java Version
 * http://www.heatonresearch.com/encog/
 * https://github.com/encog/encog-java-core
 
 * Copyright 2008-2013 Heaton Research, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *   
 * For more information on Heaton Research copyrights, licenses 
 * and trademarks visit:
 * http://www.heatonresearch.com/copyright
 */
package org.encog.neural.freeform;

import java.util.List;

import org.encog.engine.network.activation.ActivationFunction;

/**
 * Specifies how the inputs to a neuron are to be summed.
 */
public interface InputSummation {
	
	/**
	 * Add an input connection.
	 * @param connection The connection to add.
	 */
	void add(FreeformConnection connection);

	/**
	 * Perform the summation, and apply the activation function.
	 * @return The sum.
	 */
	double calculate();

	/**
	 * @return The activation function
	 */
	ActivationFunction getActivationFunction();

	/**
	 * @return The preactivation sum.
	 */
	double getSum();

	/**
	 * @return The input connections.
	 */
	List<FreeformConnection> list();
}
