/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.factory.train;

import java.util.Map;
import org.encog.EncogError;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.factory.parse.ArchitectureParse;
import org.encog.ml.svm.SVM;
import org.encog.ml.svm.training.SVMSearchTrain;
import org.encog.ml.train.MLTrain;
import org.encog.util.ParamsHolder;

public class SVMSearchFactory {
    public static final String PROPERTY_GAMMA1 = "GAMMA1";
    public static final String PROPERTY_C1 = "C1";
    public static final String PROPERTY_GAMMA2 = "GAMMA2";
    public static final String PROPERTY_C2 = "C2";
    public static final String PROPERTY_GAMMA_STEP = "GAMMASTEP";
    public static final String PROPERTY_C_STEP = "CSTEP";

    public MLTrain create(MLMethod method, MLDataSet training, String argsStr) {
        if (!(method instanceof SVM)) {
            throw new EncogError("SVM Train training cannot be used on a method of type: " + method.getClass().getName());
        }
        Map<String, String> args = ArchitectureParse.parseParams(argsStr);
        new ParamsHolder(args);
        ParamsHolder holder = new ParamsHolder(args);
        double gammaStart = holder.getDouble(PROPERTY_GAMMA1, false, 1.0);
        double cStart = holder.getDouble(PROPERTY_C1, false, 1.0);
        double gammaStop = holder.getDouble(PROPERTY_GAMMA2, false, 10.0);
        double cStop = holder.getDouble(PROPERTY_C2, false, 15.0);
        double gammaStep = holder.getDouble(PROPERTY_GAMMA_STEP, false, 1.0);
        double cStep = holder.getDouble(PROPERTY_C_STEP, false, 2.0);
        SVMSearchTrain result = new SVMSearchTrain((SVM)method, training);
        result.setGammaBegin(gammaStart);
        result.setGammaEnd(gammaStop);
        result.setGammaStep(gammaStep);
        result.setConstBegin(cStart);
        result.setConstEnd(cStop);
        result.setConstStep(cStep);
        return result;
    }
}

