/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.train.strategy.end;

import org.encog.ml.MLError;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.MLTrain;
import org.encog.ml.train.strategy.end.EndTrainingStrategy;

public class SimpleEarlyStoppingStrategy
implements EndTrainingStrategy {
    private MLDataSet validationSet;
    private MLTrain train;
    private boolean stop;
    private double trainingError;
    private double lastValidationError;
    private MLError calc;
    private int checkFrequency;
    private int lastCheck;
    private double lastError;

    public SimpleEarlyStoppingStrategy(MLDataSet theValidationSet) {
        this(theValidationSet, 5);
    }

    public SimpleEarlyStoppingStrategy(MLDataSet theValidationSet, int theCheckFrequency) {
        this.validationSet = theValidationSet;
        this.checkFrequency = theCheckFrequency;
    }

    @Override
    public void init(MLTrain theTrain) {
        this.train = theTrain;
        this.calc = (MLError)this.train.getMethod();
        this.stop = false;
        this.lastCheck = 0;
        this.lastValidationError = this.calc.calculateError(this.validationSet);
    }

    @Override
    public void preIteration() {
    }

    @Override
    public void postIteration() {
        ++this.lastCheck;
        this.trainingError = this.train.getError();
        if (this.lastCheck > this.checkFrequency || Double.isInfinite(this.lastValidationError)) {
            this.lastCheck = 0;
            double currentValidationError = this.calc.calculateError(this.validationSet);
            if (currentValidationError >= this.lastValidationError) {
                this.stop = true;
            }
            this.lastValidationError = currentValidationError;
        }
    }

    @Override
    public boolean shouldStop() {
        return this.stop;
    }

    public double getTrainingError() {
        return this.trainingError;
    }

    public double getValidationError() {
        return this.lastValidationError;
    }
}

