/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.generate.generators.js;

import java.io.File;
import org.encog.EncogError;
import org.encog.app.generate.AnalystCodeGenerationError;
import org.encog.app.generate.generators.AbstractGenerator;
import org.encog.app.generate.program.EncogGenProgram;
import org.encog.app.generate.program.EncogProgramNode;
import org.encog.app.generate.program.EncogTreeNode;
import org.encog.engine.network.activation.ActivationElliott;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationLinear;
import org.encog.engine.network.activation.ActivationSigmoid;
import org.encog.engine.network.activation.ActivationTANH;
import org.encog.ml.MLFactory;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.neural.flat.FlatNetwork;
import org.encog.neural.networks.ContainsFlat;
import org.encog.persist.EncogDirectoryPersistence;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.simple.EncogUtility;

public class GenerateEncogJavaScript
extends AbstractGenerator {
    private boolean embed;

    private void embedNetwork(EncogProgramNode node) {
        this.addBreak();
        File methodFile = (File)node.getArgs().get(0).getValue();
        MLMethod method = (MLMethod)EncogDirectoryPersistence.loadObject(methodFile);
        if (!(method instanceof MLFactory)) {
            throw new EncogError("Code generation not yet supported for: " + method.getClass().getName());
        }
        FlatNetwork flat = ((ContainsFlat)method).getFlat();
        StringBuilder line = new StringBuilder();
        line.append("public static MLMethod ");
        line.append(node.getName());
        line.append("() {");
        this.indentLine(line.toString());
        line.setLength(0);
        this.addLine("var network = ENCOG.BasicNetwork.create( null );");
        this.addLine("network.inputCount = " + flat.getInputCount() + ";");
        this.addLine("network.outputCount = " + flat.getOutputCount() + ";");
        this.addLine("network.layerCounts = " + this.toSingleLineArray(flat.getLayerCounts()) + ";");
        this.addLine("network.layerContextCount = " + this.toSingleLineArray(flat.getLayerContextCount()) + ";");
        this.addLine("network.weightIndex = " + this.toSingleLineArray(flat.getWeightIndex()) + ";");
        this.addLine("network.layerIndex = " + this.toSingleLineArray(flat.getLayerIndex()) + ";");
        this.addLine("network.activationFunctions = " + this.toSingleLineArray(flat.getActivationFunctions()) + ";");
        this.addLine("network.layerFeedCounts = " + this.toSingleLineArray(flat.getLayerFeedCounts()) + ";");
        this.addLine("network.contextTargetOffset = " + this.toSingleLineArray(flat.getContextTargetOffset()) + ";");
        this.addLine("network.contextTargetSize = " + this.toSingleLineArray(flat.getContextTargetSize()) + ";");
        this.addLine("network.biasActivation = " + this.toSingleLineArray(flat.getBiasActivation()) + ";");
        this.addLine("network.beginTraining = " + flat.getBeginTraining() + ";");
        this.addLine("network.endTraining=" + flat.getEndTraining() + ";");
        this.addLine("network.weights = WEIGHTS;");
        this.addLine("network.layerOutput = " + this.toSingleLineArray(flat.getLayerOutput()) + ";");
        this.addLine("network.layerSums = " + this.toSingleLineArray(flat.getLayerSums()) + ";");
        this.addLine("return network;");
        this.unIndentLine("}");
    }

    private void embedTraining(EncogProgramNode node) {
        StringBuilder line;
        MLData item;
        File dataFile = (File)node.getArgs().get(0).getValue();
        MLDataSet data = EncogUtility.loadEGB2Memory(dataFile);
        this.indentLine("var INPUT_DATA = [");
        for (MLDataPair pair : data) {
            item = pair.getInput();
            line = new StringBuilder();
            NumberList.toList(CSVFormat.EG_FORMAT, line, item.getData());
            line.insert(0, "[ ");
            line.append(" ],");
            this.addLine(line.toString());
        }
        this.unIndentLine("];");
        this.addBreak();
        this.indentLine("var IDEAL_DATA = [");
        for (MLDataPair pair : data) {
            item = pair.getIdeal();
            line = new StringBuilder();
            NumberList.toList(CSVFormat.EG_FORMAT, line, item.getData());
            line.insert(0, "[ ");
            line.append(" ],");
            this.addLine(line.toString());
        }
        this.unIndentLine("];");
    }

    @Override
    public void generate(EncogGenProgram program, boolean shouldEmbed) {
        if (!shouldEmbed) {
            throw new AnalystCodeGenerationError("Must embed when generating Javascript");
        }
        this.embed = shouldEmbed;
        this.generateForChildren(program);
    }

    private void generateArrayInit(EncogProgramNode node) {
        StringBuilder line = new StringBuilder();
        line.append("var ");
        line.append(node.getName());
        line.append(" = [");
        this.indentLine(line.toString());
        double[] a = (double[])node.getArgs().get(0).getValue();
        line.setLength(0);
        int lineCount = 0;
        for (int i = 0; i < a.length; ++i) {
            line.append(CSVFormat.EG_FORMAT.format(a[i], 10));
            if (i < a.length - 1) {
                line.append(",");
            }
            if (++lineCount < 10) continue;
            this.addLine(line.toString());
            line.setLength(0);
            lineCount = 0;
        }
        if (line.length() > 0) {
            this.addLine(line.toString());
            line.setLength(0);
        }
        this.unIndentLine("];");
    }

    private void generateClass(EncogProgramNode node) {
        this.addBreak();
        this.addLine("<!DOCTYPE html>");
        this.addLine("<html>");
        this.addLine("<head>");
        this.addLine("<title>Encog Generated Javascript</title>");
        this.addLine("</head>");
        this.addLine("<body>");
        this.addLine("<script src=\"../encog.js\"></script>");
        this.addLine("<script src=\"../encog-widget.js\"></script>");
        this.addLine("<pre>");
        this.addLine("<script type=\"text/javascript\">");
        this.generateForChildren(node);
        this.addLine("</script>");
        this.addLine("<noscript>Your browser does not support JavaScript! Note: if you are trying to view this in Encog Workbench, right-click file and choose \"Open as Text\".</noscript>");
        this.addLine("</pre>");
        this.addLine("</body>");
        this.addLine("</html>");
    }

    private void generateComment(EncogProgramNode commentNode) {
        this.addLine("// " + commentNode.getName());
    }

    private void generateConst(EncogProgramNode node) {
        StringBuilder line = new StringBuilder();
        line.append("var ");
        line.append(node.getName());
        line.append(" = \"");
        line.append(node.getArgs().get(0).getValue());
        line.append("\";");
        this.addLine(line.toString());
    }

    private void generateForChildren(EncogTreeNode parent) {
        for (EncogProgramNode node : parent.getChildren()) {
            this.generateNode(node);
        }
    }

    private void generateFunction(EncogProgramNode node) {
        this.addBreak();
        StringBuilder line = new StringBuilder();
        line.append("function ");
        line.append(node.getName());
        line.append("() {");
        this.indentLine(line.toString());
        this.generateForChildren(node);
        this.unIndentLine("}");
    }

    private void generateFunctionCall(EncogProgramNode node) {
        this.addBreak();
        StringBuilder line = new StringBuilder();
        if (node.getArgs().get(0).getValue().toString().length() > 0) {
            line.append("var ");
            line.append(node.getArgs().get(1).getValue().toString());
            line.append(" = ");
        }
        line.append(node.getName());
        line.append("();");
        this.addLine(line.toString());
    }

    private void generateMainFunction(EncogProgramNode node) {
        this.addBreak();
        this.generateForChildren(node);
    }

    private void generateNode(EncogProgramNode node) {
        switch (node.getType()) {
            case Comment: {
                this.generateComment(node);
                break;
            }
            case Class: {
                this.generateClass(node);
                break;
            }
            case MainFunction: {
                this.generateMainFunction(node);
                break;
            }
            case Const: {
                this.generateConst(node);
                break;
            }
            case StaticFunction: {
                this.generateFunction(node);
                break;
            }
            case FunctionCall: {
                this.generateFunctionCall(node);
                break;
            }
            case CreateNetwork: {
                this.embedNetwork(node);
                break;
            }
            case InitArray: {
                this.generateArrayInit(node);
                break;
            }
            case EmbedTraining: {
                this.embedTraining(node);
            }
        }
    }

    private String toSingleLineArray(ActivationFunction[] activationFunctions) {
        StringBuilder result = new StringBuilder();
        result.append('[');
        for (int i = 0; i < activationFunctions.length; ++i) {
            ActivationFunction af;
            if (i > 0) {
                result.append(',');
            }
            if ((af = activationFunctions[i]) instanceof ActivationSigmoid) {
                result.append("ENCOG.ActivationSigmoid.create()");
                continue;
            }
            if (af instanceof ActivationTANH) {
                result.append("ENCOG.ActivationTANH.create()");
                continue;
            }
            if (af instanceof ActivationLinear) {
                result.append("ENCOG.ActivationLinear.create()");
                continue;
            }
            if (af instanceof ActivationElliott) {
                result.append("ENCOG.ActivationElliott.create()");
                continue;
            }
            throw new AnalystCodeGenerationError("Unsupported activatoin function for code generation: " + af.getClass().getSimpleName());
        }
        result.append(']');
        return result.toString();
    }

    private String toSingleLineArray(double[] d) {
        StringBuilder line = new StringBuilder();
        line.append("[");
        for (int i = 0; i < d.length; ++i) {
            line.append(CSVFormat.EG_FORMAT.format(d[i], 10));
            if (i >= d.length - 1) continue;
            line.append(",");
        }
        line.append("]");
        return line.toString();
    }

    private String toSingleLineArray(int[] d) {
        StringBuilder line = new StringBuilder();
        line.append("[");
        for (int i = 0; i < d.length; ++i) {
            line.append(d[i]);
            if (i >= d.length - 1) continue;
            line.append(",");
        }
        line.append("]");
        return line.toString();
    }
}

