/*
 * Decompiled with CFR 0.152.
 */
package org.encog.app.quant.indicators;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import org.encog.app.analyst.csv.basic.BaseCachedColumn;
import org.encog.app.analyst.csv.basic.BasicCachedFile;
import org.encog.app.analyst.csv.basic.FileData;
import org.encog.app.quant.indicators.Indicator;
import org.encog.util.csv.ReadCSV;

public class ProcessIndicators
extends BasicCachedFile {
    private void allocateStorage() {
        for (BaseCachedColumn column : this.getColumns()) {
            column.allocate(this.getRecordCount());
        }
    }

    private void calculateIndicators() {
        for (BaseCachedColumn column : this.getColumns()) {
            if (!column.isOutput() || !(column instanceof Indicator)) continue;
            Indicator indicator = (Indicator)column;
            indicator.calculate(this.getColumnMapping(), this.getRecordCount());
        }
    }

    private int getBeginningIndex() {
        int result = 0;
        for (BaseCachedColumn column : this.getColumns()) {
            if (!(column instanceof Indicator)) continue;
            Indicator ind = (Indicator)column;
            result = Math.max(ind.getBeginningIndex(), result);
        }
        return result;
    }

    private int getEndingIndex() {
        int result = this.getRecordCount() - 1;
        for (BaseCachedColumn column : this.getColumns()) {
            if (!(column instanceof Indicator)) continue;
            Indicator ind = (Indicator)column;
            result = Math.min(ind.getEndingIndex(), result);
        }
        return result;
    }

    public final void process(File output) {
        this.validateAnalyzed();
        this.allocateStorage();
        this.readFile();
        this.calculateIndicators();
        this.writeCSV(output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile() {
        ReadCSV csv = null;
        try {
            csv = new ReadCSV(this.getInputFilename().toString(), this.isExpectInputHeaders(), this.getFormat());
            this.resetStatus();
            int row = 0;
            while (csv.next() && !this.shouldStop()) {
                this.updateStatus("Reading data");
                for (BaseCachedColumn column : this.getColumns()) {
                    double d;
                    if (!(column instanceof FileData) || !column.isInput()) continue;
                    FileData fd = (FileData)column;
                    String str = csv.get(fd.getIndex());
                    fd.getData()[row] = d = this.getFormat().parse(str);
                }
                ++row;
            }
        }
        finally {
            this.reportDone("Reading data");
            if (csv != null) {
                csv.close();
            }
        }
    }

    public final void renameColumn(int index, String newName) {
        this.getColumnMapping().remove(this.getColumns().get(index).getName());
        this.getColumns().get(index).setName(newName);
        this.getColumnMapping().put(newName, this.getColumns().get(index));
    }

    private void writeCSV(File filename) {
        try (PrintWriter tw = null;){
            this.resetStatus();
            tw = new PrintWriter(new FileWriter(filename));
            if (this.isExpectInputHeaders()) {
                StringBuilder line = new StringBuilder();
                for (BaseCachedColumn column : this.getColumns()) {
                    if (!column.isOutput()) continue;
                    if (line.length() > 0) {
                        line.append(this.getFormat().getSeparator());
                    }
                    line.append("\"");
                    line.append(column.getName());
                    line.append("\"");
                }
                tw.println(line.toString());
            }
            int beginningIndex = this.getBeginningIndex();
            int endingIndex = this.getEndingIndex();
            for (int row = beginningIndex; row <= endingIndex; ++row) {
                this.updateStatus("Writing data");
                StringBuilder line = new StringBuilder();
                for (BaseCachedColumn column : this.getColumns()) {
                    if (!column.isOutput()) continue;
                    if (line.length() > 0) {
                        line.append(this.getFormat().getSeparator());
                    }
                    double d = column.getData()[row];
                    line.append(this.getFormat().format(d, this.getPrecision()));
                }
                tw.println(line.toString());
            }
        }
    }
}

