/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ensemble.aggregator;

import java.util.ArrayList;
import java.util.List;
import org.encog.ensemble.EnsembleWeightedAggregator;
import org.encog.ensemble.data.EnsembleDataSet;
import org.encog.ml.data.MLData;
import org.encog.ml.data.basic.BasicMLData;

public class WeightedAveraging
implements EnsembleWeightedAggregator {
    private ArrayList<Double> weights;

    public WeightedAveraging(List<Double> weights) {
        this.weights = (ArrayList)weights;
    }

    @Override
    public void setWeights(List<Double> weights) {
        this.weights = (ArrayList)weights;
    }

    @Override
    public List<Double> getWeights() {
        return this.weights;
    }

    @Override
    public MLData evaluate(ArrayList<MLData> outputs) throws WeightMismatchException {
        int outputSize = outputs.get(0).size();
        double weightSum = 0.0;
        if (this.weights == null || this.weights.size() != outputs.size()) {
            throw new WeightMismatchException();
        }
        BasicMLData acc = new BasicMLData(outputSize);
        for (int i = 0; i < outputs.size(); ++i) {
            BasicMLData out = (BasicMLData)outputs.get(i);
            out = (BasicMLData)out.times(this.weights.get(i));
            acc = (BasicMLData)acc.plus(out);
            weightSum += this.weights.get(i).doubleValue();
        }
        if (weightSum == 0.0) {
            weightSum = 1.0;
        }
        acc = (BasicMLData)acc.times(1.0 / weightSum);
        return acc;
    }

    @Override
    public String getLabel() {
        return "weightedaveraging";
    }

    @Override
    public void train() {
    }

    @Override
    public void setTrainingSet(EnsembleDataSet trainingSet) {
    }

    @Override
    public boolean needsTraining() {
        return false;
    }

    @Override
    public void setNumberOfMembers(int members) {
    }

    public class WeightMismatchException
    extends Exception {
        private static final long serialVersionUID = 327652547599703252L;
    }
}

