/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ensemble.data.factories;

import java.util.ArrayList;
import java.util.Random;
import org.encog.ensemble.data.EnsembleDataSet;
import org.encog.ensemble.data.factories.EnsembleDataSetFactory;
import org.encog.ml.data.MLDataPair;

public class NonResamplingDataSetFactory
extends EnsembleDataSetFactory {
    private ArrayList<MLDataPair> elementsLeft = new ArrayList();

    public NonResamplingDataSetFactory(int dataSetSize) {
        super(dataSetSize);
    }

    @Override
    public void reload() {
        this.elementsLeft.clear();
        for (MLDataPair dp : this.dataSource) {
            this.elementsLeft.add(dp);
        }
    }

    @Override
    public EnsembleDataSet getNewDataSet() {
        Random generator = new Random();
        EnsembleDataSet ds = new EnsembleDataSet(this.dataSource.getInputSize(), this.dataSource.getIdealSize());
        for (int i = 0; i < Math.min(this.dataSetSize, this.elementsLeft.size()); ++i) {
            int candidate = generator.nextInt(this.elementsLeft.size());
            ds.add(this.elementsLeft.remove(candidate));
        }
        return ds;
    }
}

