/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ensemble.ml.mlp.factory;

import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.ensemble.EnsembleMLMethodFactory;
import org.encog.ml.MLMethod;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.layers.BasicLayer;

public class MultiLayerPerceptronFactory
implements EnsembleMLMethodFactory {
    List<Integer> layers;
    List<Double> dropoutRates;
    ActivationFunction activation;
    ActivationFunction lastLayerActivation;
    ActivationFunction firstLayerActivation;
    int sizeMultiplier = 1;

    public void setParameters(List<Integer> layers, ActivationFunction firstLayerActivation, ActivationFunction activation, ActivationFunction lastLayerActivation, List<Double> dropoutRates) {
        this.layers = layers;
        this.activation = activation;
        this.firstLayerActivation = firstLayerActivation;
        this.lastLayerActivation = lastLayerActivation;
        this.dropoutRates = dropoutRates;
    }

    public void setParameters(List<Integer> layers, ActivationFunction firstLayerActivation, ActivationFunction activation, ActivationFunction lastLayerActivation) {
        this.setParameters(layers, firstLayerActivation, activation, lastLayerActivation, null);
    }

    public void setParameters(List<Integer> layers, ActivationFunction firstLayerActivation, ActivationFunction activation) {
        this.setParameters(layers, firstLayerActivation, activation, activation, null);
    }

    public void setParameters(List<Integer> layers, ActivationFunction firstLayerActivation, ActivationFunction activation, List<Double> dropoutRates) {
        this.setParameters(layers, firstLayerActivation, activation, activation, dropoutRates);
    }

    public void setParameters(List<Integer> layers, ActivationFunction activation, List<Double> dropoutRates) {
        this.setParameters(layers, activation, activation, activation, dropoutRates);
    }

    public void setParameters(List<Integer> layers, ActivationFunction activation) {
        this.setParameters(layers, activation, activation, activation, null);
    }

    @Override
    public MLMethod createML(int inputs, int outputs) {
        BasicNetwork network = new BasicNetwork();
        if (this.dropoutRates != null) {
            network.addLayer(new BasicLayer(this.activation, false, inputs, (double)this.dropoutRates.get(0)));
        } else {
            network.addLayer(new BasicLayer(this.activation, false, inputs));
        }
        for (int i = 0; i < this.layers.size(); ++i) {
            if (this.dropoutRates != null) {
                network.addLayer(new BasicLayer(this.activation, true, this.layers.get(i) * this.sizeMultiplier, (double)this.dropoutRates.get(i + 1)));
                continue;
            }
            network.addLayer(new BasicLayer(this.activation, true, this.layers.get(i) * this.sizeMultiplier));
        }
        if (this.dropoutRates != null) {
            network.addLayer(new BasicLayer(this.lastLayerActivation, true, outputs, (double)this.dropoutRates.get(this.dropoutRates.size() - 1)));
        } else {
            network.addLayer(new BasicLayer(this.lastLayerActivation, true, outputs));
        }
        network.getStructure().finalizeStructure(this.dropoutRates != null);
        network.reset();
        return network;
    }

    private String getLayerLabel(int i) {
        if (this.dropoutRates != null && this.dropoutRates.size() > i + 2) {
            return this.layers.get(i).toString() + ":" + this.dropoutRates.get(i + 1).toString();
        }
        return this.layers.get(i).toString();
    }

    @Override
    public String getLabel() {
        String ret = "mlp{";
        for (int i = 0; i < this.layers.size() - 1; ++i) {
            ret = ret + this.getLayerLabel(i) + ",";
        }
        return ret + this.getLayerLabel(this.layers.size() - 1) + "}-" + this.firstLayerActivation.getLabel() + "," + this.activation.getLabel() + "," + this.lastLayerActivation.getLabel();
    }

    @Override
    public void reInit(MLMethod ml) {
        ((BasicNetwork)ml).reset();
    }

    @Override
    public void setSizeMultiplier(int sizeMultiplier) {
        this.sizeMultiplier = sizeMultiplier;
    }
}

