/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ensemble.training;

import org.encog.ensemble.EnsembleTrainFactory;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.MLTrain;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.propagation.back.Backpropagation;

public class BackpropagationFactory
implements EnsembleTrainFactory {
    private double dropoutRate = 0.0;

    @Override
    public MLTrain getTraining(MLMethod mlMethod, MLDataSet trainingData) {
        return this.getTraining(mlMethod, trainingData, this.dropoutRate);
    }

    @Override
    public MLTrain getTraining(MLMethod mlMethod, MLDataSet trainingData, double dropoutRate) {
        Backpropagation bp = new Backpropagation((BasicNetwork)mlMethod, trainingData);
        bp.setDroupoutRate(dropoutRate);
        return bp;
    }

    @Override
    public String getLabel() {
        String l = "backprop";
        if (this.dropoutRate > 0.0) {
            l = l + "=" + this.dropoutRate;
        }
        return l;
    }

    @Override
    public void setDropoutRate(double rate) {
        this.dropoutRate = rate;
    }
}

