/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ensemble.training;

import org.encog.ensemble.EnsembleTrainFactory;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.MLTrain;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.propagation.manhattan.ManhattanPropagation;

public class ManhattanPropagationFactory
implements EnsembleTrainFactory {
    private double learningRate = 0.01;
    private double dropoutRate = 0.0;

    public void setLearningRate(double learningRate) {
        this.learningRate = learningRate;
    }

    public double getLearningRate() {
        return this.learningRate;
    }

    @Override
    public MLTrain getTraining(MLMethod mlMethod, MLDataSet trainingData) {
        return this.getTraining(mlMethod, trainingData, this.dropoutRate);
    }

    @Override
    public MLTrain getTraining(MLMethod mlMethod, MLDataSet trainingData, double dropoutRate) {
        ManhattanPropagation mp = new ManhattanPropagation((BasicNetwork)mlMethod, trainingData, 0.01);
        mp.setDroupoutRate(dropoutRate);
        return mp;
    }

    @Override
    public String getLabel() {
        String l = "manhattanprop" + this.learningRate;
        if (this.dropoutRate > 0.0) {
            l = l + "=" + this.dropoutRate;
        }
        return l;
    }

    @Override
    public void setDropoutRate(double rate) {
        this.dropoutRate = rate;
    }
}

