/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ensemble.training;

import org.encog.ensemble.EnsembleTrainFactory;
import org.encog.ml.MLMethod;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.train.MLTrain;
import org.encog.neural.networks.BasicNetwork;
import org.encog.neural.networks.training.propagation.resilient.RPROPType;
import org.encog.neural.networks.training.propagation.resilient.ResilientPropagation;

public class ResilientPropagationFactory
implements EnsembleTrainFactory {
    private double dropoutRate = 0.0;
    private RPROPType type = RPROPType.RPROPp;

    @Override
    public MLTrain getTraining(MLMethod mlMethod, MLDataSet trainingData) {
        ResilientPropagation rp = new ResilientPropagation((BasicNetwork)mlMethod, trainingData);
        rp.setRPROPType(this.type);
        rp.setDroupoutRate(this.dropoutRate);
        return rp;
    }

    @Override
    public MLTrain getTraining(MLMethod mlMethod, MLDataSet trainingData, double dropoutRate) {
        ResilientPropagation rp = new ResilientPropagation((BasicNetwork)mlMethod, trainingData);
        rp.setRPROPType(this.type);
        rp.setDroupoutRate(dropoutRate);
        return rp;
    }

    @Override
    public String getLabel() {
        String l = "resprop";
        if (this.dropoutRate > 0.0) {
            l = l + "-" + this.dropoutRate;
        }
        return l;
    }

    @Override
    public void setDropoutRate(double rate) {
        this.dropoutRate = rate;
    }

    public RPROPType getRPROPType() {
        return this.type;
    }

    public void setRPROPType(RPROPType type) {
        this.type = type;
    }
}

