/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.error;

import org.encog.mathutil.error.ErrorCalculationMode;

public class ErrorCalculation {
    private static ErrorCalculationMode mode = ErrorCalculationMode.MSE;
    private double globalError;
    private int setSize;
    private double sum;
    private double min;
    private double max;

    public static ErrorCalculationMode getMode() {
        return mode;
    }

    public static void setMode(ErrorCalculationMode theMode) {
        mode = theMode;
    }

    public final double calculate() {
        if (this.setSize == 0) {
            return 0.0;
        }
        switch (ErrorCalculation.getMode()) {
            case RMS: {
                return this.calculateRMS();
            }
            case MSE: {
                return this.calculateMSE();
            }
            case ESS: {
                return this.calculateESS();
            }
            case LOGLOSS: 
            case HOT_LOGLOSS: {
                return this.calculateLogLoss();
            }
            case NRMSE_MEAN: {
                return this.calculateMeanNRMSE();
            }
            case NRMSE_RANGE: {
                return this.calculateRangeNRMSE();
            }
        }
        return this.calculateMSE();
    }

    public final double calculateMSE() {
        if (this.setSize == 0) {
            return 0.0;
        }
        double err = this.globalError / (double)this.setSize;
        return err;
    }

    public final double calculateESS() {
        if (this.setSize == 0) {
            return 0.0;
        }
        double err = this.globalError / 2.0;
        return err;
    }

    public final double calculateMeanNRMSE() {
        return this.calculateRMS() / (this.sum / (double)this.setSize);
    }

    public final double calculateRangeNRMSE() {
        return this.calculateRMS() / (this.max - this.min);
    }

    public final double calculateRMS() {
        if (this.setSize == 0) {
            return 0.0;
        }
        double err = Math.sqrt(this.globalError / (double)this.setSize);
        return err;
    }

    public final double calculateLogLoss() {
        return this.globalError * (-1.0 / (double)this.setSize);
    }

    public final void reset() {
        this.globalError = 0.0;
        this.setSize = 0;
    }

    public final void updateError(double actual, double ideal) {
        if (ErrorCalculation.getMode() == ErrorCalculationMode.LOGLOSS || ErrorCalculation.getMode() == ErrorCalculationMode.HOT_LOGLOSS) {
            this.globalError += Math.log(actual) * ideal;
            ++this.setSize;
        } else {
            double delta = ideal - actual;
            this.globalError += delta * delta;
            this.sum += ideal;
            if (this.setSize == 0) {
                this.min = this.max = actual;
            } else {
                this.min = Math.min(actual, this.min);
                this.max = Math.max(actual, this.max);
            }
            ++this.setSize;
        }
    }

    public final void updateError(double[] actual, double[] ideal, double significance) {
        if (ErrorCalculation.getMode() == ErrorCalculationMode.HOT_LOGLOSS) {
            ++this.setSize;
            for (int i = 0; i < actual.length; ++i) {
                if (!(ideal[i] > 1.0E-13)) continue;
                this.globalError += Math.log(actual[i]) * ideal[i];
            }
        } else if (ErrorCalculation.getMode() == ErrorCalculationMode.LOGLOSS) {
            ++this.setSize;
            this.globalError += Math.log(actual[(int)ideal[0]]);
        } else {
            for (int i = 0; i < actual.length; ++i) {
                double delta = (ideal[i] - actual[i]) * significance;
                this.sum += ideal[i];
                if (this.setSize == 0) {
                    this.min = this.max = actual[i];
                } else {
                    this.min = Math.min(actual[i], this.min);
                    this.max = Math.max(actual[i], this.max);
                }
                this.globalError += delta * delta;
            }
            this.setSize += ideal.length;
        }
    }
}

