/*
 * Decompiled with CFR 0.152.
 */
package org.encog.mathutil.matrices;

import org.encog.mathutil.matrices.Matrix;
import org.encog.mathutil.matrices.MatrixError;
import org.encog.mathutil.matrices.decomposition.LUDecomposition;

public final class MatrixMath {
    public static Matrix add(Matrix a, Matrix b) {
        if (a.getRows() != b.getRows()) {
            throw new MatrixError("To add the matrices they must have the same number of rows and columns.  Matrix a has " + a.getRows() + " rows and matrix b has " + b.getRows() + " rows.");
        }
        if (a.getCols() != b.getCols()) {
            throw new MatrixError("To add the matrices they must have the same number of rows and columns.  Matrix a has " + a.getCols() + " cols and matrix b has " + b.getCols() + " cols.");
        }
        double[][] aa = a.getData();
        double[][] bb = b.getData();
        double[][] result = new double[a.getRows()][a.getCols()];
        for (int resultRow = 0; resultRow < a.getRows(); ++resultRow) {
            for (int resultCol = 0; resultCol < a.getCols(); ++resultCol) {
                result[resultRow][resultCol] = aa[resultRow][resultCol] + bb[resultRow][resultCol];
            }
        }
        return new Matrix(result);
    }

    public static void copy(Matrix source, Matrix target) {
        double[][] s = source.getData();
        double[][] t = target.getData();
        for (int row = 0; row < source.getRows(); ++row) {
            for (int col = 0; col < source.getCols(); ++col) {
                t[row][col] = s[row][col];
            }
        }
    }

    public static Matrix deleteCol(Matrix matrix, int deleted) {
        if (deleted >= matrix.getCols()) {
            throw new MatrixError("Can't delete column " + deleted + " from matrix, it only has " + matrix.getCols() + " columns.");
        }
        double[][] newMatrix = new double[matrix.getRows()][matrix.getCols() - 1];
        double[][] d = matrix.getData();
        for (int row = 0; row < matrix.getRows(); ++row) {
            int targetCol = 0;
            for (int col = 0; col < matrix.getCols(); ++col) {
                if (col == deleted) continue;
                newMatrix[row][targetCol] = d[row][col];
                ++targetCol;
            }
        }
        return new Matrix(newMatrix);
    }

    public static Matrix deleteRow(Matrix matrix, int deleted) {
        if (deleted >= matrix.getRows()) {
            throw new MatrixError("Can't delete row " + deleted + " from matrix, it only has " + matrix.getRows() + " rows.");
        }
        double[][] newMatrix = new double[matrix.getRows() - 1][matrix.getCols()];
        double[][] d = matrix.getData();
        int targetRow = 0;
        for (int row = 0; row < matrix.getRows(); ++row) {
            if (row == deleted) continue;
            for (int col = 0; col < matrix.getCols(); ++col) {
                newMatrix[targetRow][col] = d[row][col];
            }
            ++targetRow;
        }
        return new Matrix(newMatrix);
    }

    public static Matrix divide(Matrix a, double b) {
        double[][] result = new double[a.getRows()][a.getCols()];
        double[][] d = a.getData();
        for (int row = 0; row < a.getRows(); ++row) {
            for (int col = 0; col < a.getCols(); ++col) {
                result[row][col] = d[row][col] / b;
            }
        }
        return new Matrix(result);
    }

    public static double dotProduct(Matrix a, Matrix b) {
        double result;
        block7: {
            int aLength;
            double[][] bArray;
            double[][] aArray;
            block9: {
                block8: {
                    block6: {
                        int bLength;
                        if (!a.isVector() || !b.isVector()) {
                            throw new MatrixError("To take the dot product, both matrices must be vectors.");
                        }
                        aArray = a.getData();
                        bArray = b.getData();
                        aLength = aArray.length == 1 ? aArray[0].length : aArray.length;
                        int n = bLength = bArray.length == 1 ? bArray[0].length : bArray.length;
                        if (aLength != bLength) {
                            throw new MatrixError("To take the dot product, both matrices must be of the same length.");
                        }
                        result = 0.0;
                        if (aArray.length != 1 || bArray.length != 1) break block6;
                        for (int i = 0; i < aLength; ++i) {
                            result += aArray[0][i] * bArray[0][i];
                        }
                        break block7;
                    }
                    if (aArray.length != 1 || bArray[0].length != 1) break block8;
                    for (int i = 0; i < aLength; ++i) {
                        result += aArray[0][i] * bArray[i][0];
                    }
                    break block7;
                }
                if (aArray[0].length != 1 || bArray.length != 1) break block9;
                for (int i = 0; i < aLength; ++i) {
                    result += aArray[i][0] * bArray[0][i];
                }
                break block7;
            }
            if (aArray[0].length != 1 || bArray[0].length != 1) break block7;
            for (int i = 0; i < aLength; ++i) {
                result += aArray[i][0] * bArray[i][0];
            }
        }
        return result;
    }

    public static Matrix identity(int size) {
        if (size < 1) {
            throw new MatrixError("Identity matrix must be at least of size 1.");
        }
        Matrix result = new Matrix(size, size);
        double[][] d = result.getData();
        for (int i = 0; i < size; ++i) {
            d[i][i] = 1.0;
        }
        return result;
    }

    public static Matrix multiply(Matrix a, double b) {
        double[][] result = new double[a.getRows()][a.getCols()];
        double[][] d = a.getData();
        for (int row = 0; row < a.getRows(); ++row) {
            for (int col = 0; col < a.getCols(); ++col) {
                result[row][col] = d[row][col] * b;
            }
        }
        return new Matrix(result);
    }

    public static Matrix multiply(Matrix a, Matrix b) {
        if (b.getRows() != a.getCols()) {
            throw new MatrixError("To use ordinary matrix multiplication the number of columns on the first matrix must mat the number of rows on the second.");
        }
        double[][] aData = a.getData();
        double[][] bData = b.getData();
        Matrix x = new Matrix(a.getRows(), b.getCols());
        double[][] c = x.getData();
        double[] bcolj = new double[a.getCols()];
        for (int j = 0; j < b.getCols(); ++j) {
            for (int k = 0; k < a.getCols(); ++k) {
                bcolj[k] = bData[k][j];
            }
            for (int i = 0; i < a.getRows(); ++i) {
                double[] arowi = aData[i];
                double s = 0.0;
                for (int k = 0; k < a.getCols(); ++k) {
                    s += arowi[k] * bcolj[k];
                }
                c[i][j] = s;
            }
        }
        return x;
    }

    public static Matrix subtract(Matrix a, Matrix b) {
        if (a.getRows() != b.getRows()) {
            throw new MatrixError("To subtract the matrices they must have the same number of rows and columns.  Matrix a has " + a.getRows() + " rows and matrix b has " + b.getRows() + " rows.");
        }
        if (a.getCols() != b.getCols()) {
            throw new MatrixError("To subtract the matrices they must have the same number of rows and columns.  Matrix a has " + a.getCols() + " cols and matrix b has " + b.getCols() + " cols.");
        }
        double[][] result = new double[a.getRows()][a.getCols()];
        double[][] aa = a.getData();
        double[][] bb = b.getData();
        for (int resultRow = 0; resultRow < a.getRows(); ++resultRow) {
            for (int resultCol = 0; resultCol < a.getCols(); ++resultCol) {
                result[resultRow][resultCol] = aa[resultRow][resultCol] - bb[resultRow][resultCol];
            }
        }
        return new Matrix(result);
    }

    public static Matrix transpose(Matrix input) {
        double[][] transposeMatrix = new double[input.getCols()][input.getRows()];
        double[][] d = input.getData();
        for (int r = 0; r < input.getRows(); ++r) {
            for (int c = 0; c < input.getCols(); ++c) {
                transposeMatrix[c][r] = d[r][c];
            }
        }
        return new Matrix(transposeMatrix);
    }

    public static double vectorLength(Matrix input) {
        if (!input.isVector()) {
            throw new MatrixError("Can only take the vector length of a vector.");
        }
        double[] v = input.toPackedArray();
        double rtn = 0.0;
        double[] dArray = v;
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            Double element = dArray[i];
            rtn += Math.pow(element, 2.0);
        }
        return Math.sqrt(rtn);
    }

    private MatrixMath() {
    }

    public static double determinant(Matrix m) {
        return new LUDecomposition(m).det();
    }

    public static double[] multiply(Matrix a, double[] d) {
        double[] p = new double[a.getRows()];
        double[][] aData = a.getData();
        for (int r = 0; r < a.getRows(); ++r) {
            for (int i = 0; i < a.getCols(); ++i) {
                int n = r;
                p[n] = p[n] + aData[r][i] * d[i];
            }
        }
        return p;
    }
}

