/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.versatile.columns;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.EncogError;
import org.encog.ml.data.versatile.NormalizationHelper;
import org.encog.ml.data.versatile.columns.ColumnType;
import org.encog.util.Format;

public class ColumnDefinition
implements Serializable {
    private String name;
    private ColumnType dataType;
    private double low;
    private double high;
    private double mean;
    private double sd;
    private int count;
    private int index;
    private final List<String> classes = new ArrayList<String>();
    private NormalizationHelper owner;

    public ColumnDefinition(String theName, ColumnType theDataType) {
        this.name = theName;
        this.dataType = theDataType;
        this.count = -1;
        this.index = -1;
        this.sd = Double.NaN;
        this.mean = Double.NaN;
        this.high = Double.NaN;
        this.low = Double.NaN;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ColumnType getDataType() {
        return this.dataType;
    }

    public void setDataType(ColumnType dataType) {
        this.dataType = dataType;
    }

    public double getLow() {
        return this.low;
    }

    public void setLow(double low) {
        this.low = low;
    }

    public double getHigh() {
        return this.high;
    }

    public void setHigh(double high) {
        this.high = high;
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double mean) {
        this.mean = mean;
    }

    public double getSd() {
        return this.sd;
    }

    public void setSd(double sd) {
        this.sd = sd;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void analyze(String value) {
        switch (this.dataType) {
            case continuous: {
                this.analyzeContinuous(value);
                break;
            }
            case ordinal: {
                this.analyzeOrdinal(value);
                break;
            }
            case nominal: {
                this.analyzeNominal(value);
            }
        }
    }

    private void analyzeNominal(String value) {
        if (!this.classes.contains(value)) {
            this.classes.add(value);
        }
    }

    private void analyzeOrdinal(String value) {
        if (!this.classes.contains(value)) {
            throw new EncogError("You must predefine any ordinal values (in order). Undefined ordinal value: " + value);
        }
    }

    private void analyzeContinuous(String value) {
        double d = this.owner.getFormat().parse(value);
        if (this.count < 0) {
            this.low = d;
            this.high = d;
            this.mean = d;
            this.sd = 0.0;
            this.count = 1;
        } else {
            this.mean += d;
            this.low = Math.min(this.low, d);
            this.high = Math.max(this.high, d);
            ++this.count;
        }
    }

    public List<String> getClasses() {
        return this.classes;
    }

    public boolean equals(Object obj) {
        boolean result;
        if (obj instanceof ColumnDefinition) {
            ColumnDefinition that = (ColumnDefinition)obj;
            result = (this.name == that.name || null != this.name && this.name.equals(that.name)) && this.dataType == that.dataType && Double.valueOf(this.low).equals(that.low) && Double.valueOf(this.high).equals(that.high) && Double.valueOf(this.mean).equals(that.mean) && Double.valueOf(this.sd).equals(that.sd) && this.count == that.count && this.index == that.index && this.classes.equals(that.classes);
        } else {
            result = false;
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        result.append("ColumnDefinition:");
        result.append(this.name);
        result.append("(");
        result.append(this.dataType.toString());
        result.append(")");
        if (this.dataType == ColumnType.continuous) {
            result.append(";low=");
            result.append(Format.formatDouble(this.low, 6));
            result.append(",high=");
            result.append(Format.formatDouble(this.high, 6));
            result.append(",mean=");
            result.append(Format.formatDouble(this.mean, 6));
            result.append(",sd=");
            result.append(Format.formatDouble(this.sd, 6));
        } else {
            result.append(";");
            result.append(this.classes.toString());
        }
        result.append("]");
        return result.toString();
    }

    public void defineClass(String str) {
        this.classes.add(str);
    }

    public void defineClass(String[] str) {
        for (String s : str) {
            this.defineClass(s);
        }
    }

    public void setOwner(NormalizationHelper theOwner) {
        this.owner = theOwner;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }
}

