/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.genetic;

import org.encog.ml.CalculateScore;
import org.encog.ml.MLEncodable;
import org.encog.ml.MLMethod;
import org.encog.ml.MethodFactory;
import org.encog.ml.TrainingImplementationType;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.population.BasicPopulation;
import org.encog.ml.ea.population.Population;
import org.encog.ml.ea.sort.AbstractGenomeComparator;
import org.encog.ml.ea.sort.MaximizeScoreComp;
import org.encog.ml.ea.sort.MinimizeScoreComp;
import org.encog.ml.ea.species.Species;
import org.encog.ml.ea.train.basic.TrainEA;
import org.encog.ml.genetic.MLEncodableCODEC;
import org.encog.ml.genetic.MLMethodGenome;
import org.encog.ml.genetic.MLMethodGenomeFactory;
import org.encog.ml.genetic.crossover.Splice;
import org.encog.ml.genetic.mutate.MutatePerturb;
import org.encog.ml.train.BasicTraining;
import org.encog.neural.networks.training.propagation.TrainingContinuation;
import org.encog.util.concurrency.MultiThreadable;
import org.encog.util.logging.EncogLogging;

public class MLMethodGeneticAlgorithm
extends BasicTraining
implements MultiThreadable {
    private MLMethodGeneticAlgorithmHelper genetic;

    public MLMethodGeneticAlgorithm(MethodFactory phenotypeFactory, CalculateScore calculateScore, int populationSize) {
        super(TrainingImplementationType.Iterative);
        BasicPopulation population = new BasicPopulation(populationSize, null);
        Species defaultSpecies = population.createSpecies();
        for (int i = 0; i < population.getPopulationSize(); ++i) {
            MLEncodable chromosomeNetwork = (MLEncodable)phenotypeFactory.factor();
            MLMethodGenome genome = new MLMethodGenome(chromosomeNetwork);
            defaultSpecies.add(genome);
        }
        defaultSpecies.setLeader(defaultSpecies.getMembers().get(0));
        population.setGenomeFactory(new MLMethodGenomeFactory(phenotypeFactory, population));
        this.genetic = new MLMethodGeneticAlgorithmHelper(population, calculateScore);
        this.genetic.setCODEC(new MLEncodableCODEC());
        AbstractGenomeComparator comp = null;
        comp = calculateScore.shouldMinimize() ? new MinimizeScoreComp() : new MaximizeScoreComp();
        this.genetic.setBestComparator(comp);
        this.genetic.setSelectionComparator(comp);
        int s = Math.max(defaultSpecies.getMembers().get(0).size() / 5, 1);
        this.getGenetic().setPopulation(population);
        this.genetic.addOperation(0.9, new Splice(s));
        this.genetic.addOperation(0.1, new MutatePerturb(1.0));
    }

    @Override
    public boolean canContinue() {
        return false;
    }

    public MLMethodGeneticAlgorithmHelper getGenetic() {
        return this.genetic;
    }

    @Override
    public MLMethod getMethod() {
        Genome best = this.genetic.getBestGenome();
        return this.genetic.getCODEC().decode(best);
    }

    @Override
    public int getThreadCount() {
        return this.genetic.getThreadCount();
    }

    @Override
    public void iteration() {
        EncogLogging.log(1, "Performing Genetic iteration.");
        this.preIteration();
        this.setError(this.getGenetic().getError());
        this.getGenetic().iteration();
        this.setError(this.getGenetic().getError());
        this.postIteration();
    }

    @Override
    public TrainingContinuation pause() {
        return null;
    }

    @Override
    public void resume(TrainingContinuation state) {
    }

    @Override
    public void finishTraining() {
        super.finishTraining();
        this.genetic.finishTraining();
    }

    public void setGenetic(MLMethodGeneticAlgorithmHelper genetic) {
        this.genetic = genetic;
    }

    @Override
    public void setThreadCount(int numThreads) {
        this.genetic.setThreadCount(numThreads);
    }

    public class MLMethodGeneticAlgorithmHelper
    extends TrainEA {
        private static final long serialVersionUID = 1L;

        public MLMethodGeneticAlgorithmHelper(Population thePopulation, CalculateScore theScoreFunction) {
            super(thePopulation, theScoreFunction);
        }
    }
}

