/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.importance;

import org.encog.EncogError;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.importance.AbstractFeatureImportance;
import org.encog.ml.importance.FeatureRank;

public class CorrelationFeatureImportanceCalc
extends AbstractFeatureImportance {
    @Override
    public void performRanking() {
        throw new EncogError("This algorithm requires a dataset to measure performance against, please call performRanking with a dataset.");
    }

    @Override
    public void performRanking(MLDataSet theDataset) {
        int i;
        if (this.getModel() != null) {
            throw new EncogError("This algorithm does not use a model, please pass null to init for the model.");
        }
        if (theDataset.getIdealSize() != 1) {
            throw new EncogError("This algorithm can only be used with a single-output dataset.");
        }
        double[] mean = new double[1 + theDataset.getInputSize()];
        for (Object pair : theDataset) {
            mean[0] = mean[0] + pair.getIdeal().getData(0);
            for (int i2 = 0; i2 < pair.getInput().size(); ++i2) {
                int n = 1 + i2;
                mean[n] = mean[n] + pair.getInput().getData(i2);
            }
        }
        int i3 = 0;
        while (i3 < mean.length) {
            int n = i3++;
            mean[n] = mean[n] / (double)theDataset.size();
        }
        double[] sd = new double[1 + theDataset.getInputSize()];
        for (MLDataPair pair : theDataset) {
            double d = pair.getIdeal().getData(0) - mean[0];
            sd[0] = sd[0] + d * d;
            for (int i4 = 0; i4 < pair.getInput().size(); ++i4) {
                d = pair.getInput().getData(i4) - mean[1 + i4];
                int n = 1 + i4;
                sd[n] = sd[n] + d * d;
            }
        }
        for (i = 0; i < mean.length; ++i) {
            sd[i] = Math.sqrt(sd[i] / (double)theDataset.size());
        }
        for (i = 0; i < theDataset.getInputSize(); ++i) {
            FeatureRank rank = this.getFeatures().get(i);
            double acc = 0.0;
            for (MLDataPair pair : theDataset) {
                double a = pair.getIdeal().getData(0) - mean[0];
                double b = pair.getInput().getData(i) - mean[i + 1];
                acc += a * b;
            }
            double cov = 1.0 / (1.0 - (double)theDataset.size()) * acc;
            double cor = cov / (sd[0] * sd[i + 1]);
            rank.setImportancePercent(Math.abs(cor));
            rank.setTotalWeight(cor);
        }
    }
}

