/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.importance;

import org.encog.EncogError;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.importance.AbstractFeatureImportance;
import org.encog.ml.importance.FeatureRank;
import org.encog.neural.networks.BasicNetwork;

public class NeuralFeatureImportanceCalc
extends AbstractFeatureImportance {
    @Override
    public void performRanking() {
        for (FeatureRank rank : this.getFeatures()) {
            rank.setImportancePercent(0.0);
            rank.setTotalWeight(0.0);
        }
        if (!(this.getModel() instanceof BasicNetwork)) {
            throw new EncogError("This algorithm only works for classes of type BasicNetwork");
        }
        BasicNetwork network = (BasicNetwork)this.getModel();
        for (int inputNueron = 0; inputNueron < network.getInputCount(); ++inputNueron) {
            FeatureRank ranking = this.getFeatures().get(inputNueron);
            for (int nextNeuron = 0; nextNeuron < network.getLayerNeuronCount(1); ++nextNeuron) {
                double i_h = network.getWeight(0, inputNueron, nextNeuron);
                double h_o = network.getWeight(1, nextNeuron, 0);
                ranking.addWeight(i_h * h_o);
            }
        }
        double max = 0.0;
        for (FeatureRank rank : this.getFeatures()) {
            max = Math.max(max, Math.abs(rank.getTotalWeight()));
        }
        for (FeatureRank rank : this.getFeatures()) {
            rank.setImportancePercent(Math.abs(rank.getTotalWeight()) / max);
        }
    }

    @Override
    public void performRanking(MLDataSet theDataset) {
        this.performRanking();
    }
}

