/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.extension;

import java.util.List;
import java.util.Random;
import org.encog.mathutil.randomize.generate.GenerateRandom;
import org.encog.mathutil.randomize.generate.MersenneTwisterGenerateRandom;
import org.encog.ml.prg.EncogProgramContext;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.expvalue.ExpressionValue;
import org.encog.ml.prg.expvalue.ValueType;
import org.encog.ml.prg.extension.NodeType;
import org.encog.ml.prg.extension.ParamTemplate;
import org.encog.ml.prg.extension.ProgramExtensionTemplate;

public class ConstantPool
implements ProgramExtensionTemplate {
    public static double[] COMMON_CONST = new double[]{0.0, 1.0, 2.0, 10.0, 0.1, 0.5, 0.25};
    private final ExpressionValue[] pool;
    private final String name;
    private final ParamTemplate returnValue;

    public ConstantPool(String theName, double[] thePool) {
        this.pool = new ExpressionValue[thePool.length];
        for (int i = 0; i < thePool.length; ++i) {
            ExpressionValue value;
            this.pool[i] = value = new ExpressionValue(thePool[i]);
        }
        this.name = theName;
        this.returnValue = new ParamTemplate();
        this.returnValue.addType("f");
    }

    public ConstantPool(String theName, double[] thePool, int count, GenerateRandom rnd, double low, double high) {
        ExpressionValue value;
        int i;
        this.pool = new ExpressionValue[thePool.length + count];
        for (i = 0; i < thePool.length; ++i) {
            this.pool[i] = value = new ExpressionValue(thePool[i]);
        }
        for (i = 0; i < count; ++i) {
            this.pool[thePool.length + i] = value = new ExpressionValue(rnd.nextDouble(low, high));
        }
        this.name = theName;
        this.returnValue = new ParamTemplate();
        this.returnValue.addType("f");
    }

    public ConstantPool() {
        this("#CONST_POOL_100", COMMON_CONST, 100, new MersenneTwisterGenerateRandom(42L), -10.0, 10.0);
    }

    @Override
    public ExpressionValue evaluate(ProgramNode actual) {
        return this.pool[(int)actual.getData()[0].toIntValue()];
    }

    @Override
    public int getChildNodeCount() {
        return 0;
    }

    @Override
    public int getDataSize() {
        return 1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.Leaf;
    }

    @Override
    public List<ParamTemplate> getParams() {
        return ProgramExtensionTemplate.NO_PARAMS;
    }

    @Override
    public int getPrecedence() {
        return 100;
    }

    @Override
    public ParamTemplate getReturnValue() {
        return this.returnValue;
    }

    @Override
    public boolean isPossibleReturnType(EncogProgramContext context, ValueType rtn) {
        return this.returnValue.getPossibleTypes().contains((Object)rtn);
    }

    @Override
    public boolean isVariable() {
        return false;
    }

    @Override
    public void randomize(Random rnd, List<ValueType> desiredType, ProgramNode actual, double minValue, double maxValue) {
        actual.getData()[0] = new ExpressionValue(rnd.nextInt(this.pool.length));
    }
}

