/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.extension;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.encog.ml.prg.extension.ProgramExtensionTemplate;
import org.encog.ml.prg.extension.StandardExtensions;

public enum EncogOpcodeRegistry {
    INSTANCE;

    private final Map<String, ProgramExtensionTemplate> registry = new HashMap<String, ProgramExtensionTemplate>();

    public static String createKey(String functionName, int argCount) {
        return functionName + '`' + argCount;
    }

    private EncogOpcodeRegistry() {
        this.add(StandardExtensions.EXTENSION_NOT_EQUAL);
        this.add(StandardExtensions.EXTENSION_NOT);
        this.add(StandardExtensions.EXTENSION_VAR_SUPPORT);
        this.add(StandardExtensions.EXTENSION_CONST_SUPPORT);
        this.add(StandardExtensions.EXTENSION_NEG);
        this.add(StandardExtensions.EXTENSION_ADD);
        this.add(StandardExtensions.EXTENSION_SUB);
        this.add(StandardExtensions.EXTENSION_MUL);
        this.add(StandardExtensions.EXTENSION_DIV);
        this.add(StandardExtensions.EXTENSION_POWER);
        this.add(StandardExtensions.EXTENSION_AND);
        this.add(StandardExtensions.EXTENSION_OR);
        this.add(StandardExtensions.EXTENSION_EQUAL);
        this.add(StandardExtensions.EXTENSION_GT);
        this.add(StandardExtensions.EXTENSION_LT);
        this.add(StandardExtensions.EXTENSION_GTE);
        this.add(StandardExtensions.EXTENSION_LTE);
        this.add(StandardExtensions.EXTENSION_ABS);
        this.add(StandardExtensions.EXTENSION_ACOS);
        this.add(StandardExtensions.EXTENSION_ASIN);
        this.add(StandardExtensions.EXTENSION_ATAN);
        this.add(StandardExtensions.EXTENSION_ATAN2);
        this.add(StandardExtensions.EXTENSION_CEIL);
        this.add(StandardExtensions.EXTENSION_COS);
        this.add(StandardExtensions.EXTENSION_COSH);
        this.add(StandardExtensions.EXTENSION_EXP);
        this.add(StandardExtensions.EXTENSION_FLOOR);
        this.add(StandardExtensions.EXTENSION_LOG);
        this.add(StandardExtensions.EXTENSION_LOG10);
        this.add(StandardExtensions.EXTENSION_MAX);
        this.add(StandardExtensions.EXTENSION_MIN);
        this.add(StandardExtensions.EXTENSION_PDIV);
        this.add(StandardExtensions.EXTENSION_POWFN);
        this.add(StandardExtensions.EXTENSION_RANDOM);
        this.add(StandardExtensions.EXTENSION_ROUND);
        this.add(StandardExtensions.EXTENSION_SIN);
        this.add(StandardExtensions.EXTENSION_SINH);
        this.add(StandardExtensions.EXTENSION_SQRT);
        this.add(StandardExtensions.EXTENSION_TAN);
        this.add(StandardExtensions.EXTENSION_TANH);
        this.add(StandardExtensions.EXTENSION_TODEG);
        this.add(StandardExtensions.EXTENSION_TORAD);
        this.add(StandardExtensions.EXTENSION_LENGTH);
        this.add(StandardExtensions.EXTENSION_FORMAT);
        this.add(StandardExtensions.EXTENSION_LEFT);
        this.add(StandardExtensions.EXTENSION_RIGHT);
        this.add(StandardExtensions.EXTENSION_CINT);
        this.add(StandardExtensions.EXTENSION_CFLOAT);
        this.add(StandardExtensions.EXTENSION_CSTR);
        this.add(StandardExtensions.EXTENSION_CBOOL);
        this.add(StandardExtensions.EXTENSION_IFF);
        this.add(StandardExtensions.EXTENSION_CLAMP);
        this.add(StandardExtensions.EXTENSION_CONST_COMMON_POOL);
    }

    public void add(ProgramExtensionTemplate ext) {
        this.registry.put(EncogOpcodeRegistry.createKey(ext.getName(), ext.getChildNodeCount()), ext);
    }

    public Collection<ProgramExtensionTemplate> findAllOpcodes() {
        return this.registry.values();
    }

    public ProgramExtensionTemplate findOpcode(String name, int args) {
        String key = EncogOpcodeRegistry.createKey(name, args);
        if (this.registry.containsKey(key)) {
            return this.registry.get(key);
        }
        return null;
    }
}

