/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.prg.train.rewrite;

import org.encog.EncogError;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.rules.RewriteRule;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.expvalue.ExpressionValue;
import org.encog.ml.prg.extension.StandardExtensions;

public class RewriteAlgebraic
implements RewriteRule {
    private boolean rewritten;
    private boolean validated;

    private void validate(Genome g) {
        if (!(g instanceof EncogProgram)) {
            throw new EncogError("RewriteAlgebraic can only be used with EncogProgram genomes.");
        }
        EncogProgram prg = (EncogProgram)g;
        if (!prg.getContext().getFunctions().isDefined("^", 2)) {
            throw new EncogError("Must have power(^) operator to use RewriteAlgebraic");
        }
        if (!prg.getContext().getFunctions().isDefined("+", 2)) {
            throw new EncogError("Must have addition(+) operator to use RewriteAlgebraic");
        }
        if (!prg.getContext().getFunctions().isDefined("-", 1)) {
            throw new EncogError("Must have negative(-) operator to use RewriteAlgebraic");
        }
        if (!prg.getContext().getFunctions().isDefined("-", 2)) {
            throw new EncogError("Must have subtraction(-) operator to use RewriteAlgebraic");
        }
        if (!prg.getContext().getFunctions().isDefined("*", 2)) {
            throw new EncogError("Must have multiplication(*) operator to use RewriteAlgebraic");
        }
        if (!prg.getContext().getFunctions().isDefined("/", 2) && !prg.getContext().getFunctions().isDefined("%", 2)) {
            throw new EncogError("Must have division(/ or %) operator to use RewriteAlgebraic");
        }
        if (!prg.getContext().getFunctions().isDefined("#var", 0)) {
            throw new EncogError("Must have variables(#var) operator to use RewriteAlgebraic");
        }
    }

    private ProgramNode createNumericConst(EncogProgram prg, double v) {
        ProgramNode result = prg.getFunctions().factorProgramNode("#const", prg, new ProgramNode[0]);
        result.getData()[0] = new ExpressionValue(v);
        return result;
    }

    private ProgramNode createNumericConst(EncogProgram prg, int v) {
        ProgramNode result = prg.getFunctions().factorProgramNode("#const", prg, new ProgramNode[0]);
        result.getData()[0] = new ExpressionValue(v);
        return result;
    }

    private ProgramNode internalRewrite(ProgramNode parent) {
        ProgramNode rewrittenParent = parent;
        rewrittenParent = this.tryDoubleNegative(rewrittenParent);
        rewrittenParent = this.tryMinusMinus(rewrittenParent);
        rewrittenParent = this.tryPlusNeg(rewrittenParent);
        rewrittenParent = this.tryVarOpVar(rewrittenParent);
        rewrittenParent = this.tryPowerZero(rewrittenParent);
        rewrittenParent = this.tryOnePower(rewrittenParent);
        rewrittenParent = this.tryZeroPlus(rewrittenParent);
        rewrittenParent = this.tryZeroDiv(rewrittenParent);
        rewrittenParent = this.tryZeroMul(rewrittenParent);
        rewrittenParent = this.tryMinusZero(rewrittenParent);
        for (int i = 0; i < rewrittenParent.getChildNodes().size(); ++i) {
            ProgramNode rewriteChild;
            ProgramNode childNode = (ProgramNode)rewrittenParent.getChildNodes().get(i);
            if (childNode == (rewriteChild = this.internalRewrite(childNode))) continue;
            rewrittenParent.getChildNodes().remove(i);
            rewrittenParent.getChildNodes().add(i, rewriteChild);
            this.rewritten = true;
        }
        return rewrittenParent;
    }

    private boolean isConstValue(ProgramNode node, double v) {
        return node.getTemplate() == StandardExtensions.EXTENSION_CONST_SUPPORT && Math.abs(node.getData()[0].toFloatValue() - v) < 1.0E-13;
    }

    @Override
    public boolean rewrite(Genome g) {
        if (!this.validated) {
            this.validate(g);
            this.validated = true;
        }
        this.rewritten = false;
        EncogProgram program = (EncogProgram)g;
        ProgramNode node = program.getRootNode();
        ProgramNode rewrittenRoot = this.internalRewrite(node);
        if (rewrittenRoot != null) {
            program.setRootNode(rewrittenRoot);
        }
        return this.rewritten;
    }

    private ProgramNode tryDoubleNegative(ProgramNode parent) {
        ProgramNode child;
        if (parent.getName().equals("-") && (child = parent.getChildNode(0)).getName().equals("-")) {
            ProgramNode grandChild = child.getChildNode(0);
            this.rewritten = true;
            return grandChild;
        }
        return parent;
    }

    private ProgramNode tryMinusMinus(ProgramNode parent) {
        if (parent.getName().equals("-") && parent.getChildNodes().size() == 2) {
            ProgramNode child1 = parent.getChildNode(0);
            ProgramNode child2 = parent.getChildNode(1);
            if (child2.getName().equals("#const")) {
                long v2;
                ExpressionValue v = child2.getData()[0];
                if (v.isFloat()) {
                    double v22 = v.toFloatValue();
                    if (v22 < 0.0) {
                        child2.getData()[0] = new ExpressionValue(-v22);
                        parent = parent.getOwner().getContext().getFunctions().factorProgramNode("+", parent.getOwner(), new ProgramNode[]{child1, child2});
                    }
                } else if (v.isInt() && (v2 = v.toIntValue()) < 0L) {
                    child2.getData()[0] = new ExpressionValue(-v2);
                    parent = parent.getOwner().getContext().getFunctions().factorProgramNode("+", parent.getOwner(), new ProgramNode[]{child1, child2});
                }
            }
        }
        return parent;
    }

    private ProgramNode tryMinusZero(ProgramNode parent) {
        ProgramNode child2;
        if (parent.getTemplate() == StandardExtensions.EXTENSION_SUB && this.isConstValue(child2 = parent.getChildNode(1), 0.0)) {
            ProgramNode child1 = parent.getChildNode(0);
            return child1;
        }
        return parent;
    }

    private ProgramNode tryOnePower(ProgramNode parent) {
        ProgramNode child;
        if ((parent.getTemplate() == StandardExtensions.EXTENSION_POWER || parent.getTemplate() == StandardExtensions.EXTENSION_POWFN) && (child = parent.getChildNode(0)).getTemplate() == StandardExtensions.EXTENSION_CONST_SUPPORT && Math.abs(child.getData()[0].toFloatValue() - 1.0) < 1.0E-13) {
            this.rewritten = true;
            return this.createNumericConst(parent.getOwner(), 1);
        }
        return parent;
    }

    private ProgramNode tryPlusNeg(ProgramNode parent) {
        if (parent.getName().equals("+") && parent.getChildNodes().size() == 2) {
            ProgramNode child1 = parent.getChildNode(0);
            ProgramNode child2 = parent.getChildNode(1);
            if (child2.getName().equals("-") && child2.getChildNodes().size() == 1) {
                parent = parent.getOwner().getContext().getFunctions().factorProgramNode("-", parent.getOwner(), new ProgramNode[]{child1, child2.getChildNode(0)});
            } else if (child2.getName().equals("#const")) {
                long v2;
                ExpressionValue v = child2.getData()[0];
                if (v.isFloat()) {
                    double v22 = v.toFloatValue();
                    if (v22 < 0.0) {
                        child2.getData()[0] = new ExpressionValue(-v22);
                        parent = parent.getOwner().getContext().getFunctions().factorProgramNode("-", parent.getOwner(), new ProgramNode[]{child1, child2});
                    }
                } else if (v.isInt() && (v2 = v.toIntValue()) < 0L) {
                    child2.getData()[0] = new ExpressionValue(-v2);
                    parent = parent.getOwner().getContext().getFunctions().factorProgramNode("-", parent.getOwner(), new ProgramNode[]{child1, child2});
                }
            }
        }
        return parent;
    }

    private ProgramNode tryPowerZero(ProgramNode parent) {
        if (parent.getTemplate() == StandardExtensions.EXTENSION_POWER || parent.getTemplate() == StandardExtensions.EXTENSION_POWFN) {
            ProgramNode child0 = parent.getChildNode(0);
            ProgramNode child1 = parent.getChildNode(1);
            if (this.isConstValue(child1, 0.0)) {
                return this.createNumericConst(parent.getOwner(), 1);
            }
            if (this.isConstValue(child0, 0.0)) {
                return this.createNumericConst(parent.getOwner(), 0);
            }
        }
        return parent;
    }

    private ProgramNode tryVarOpVar(ProgramNode parent) {
        if (parent.getChildNodes().size() == 2 && parent.getName().length() == 1 && "+-*/".indexOf(parent.getName().charAt(0)) != -1) {
            ProgramNode child1 = parent.getChildNode(0);
            ProgramNode child2 = parent.getChildNode(1);
            if (child1.getName().equals("#var") && child2.getName().equals("#var") && child1.getData()[0].toIntValue() == child2.getData()[0].toIntValue()) {
                switch (parent.getName().charAt(0)) {
                    case '-': {
                        parent = this.createNumericConst(parent.getOwner(), 0);
                        break;
                    }
                    case '+': {
                        parent = parent.getOwner().getFunctions().factorProgramNode("*", parent.getOwner(), new ProgramNode[]{this.createNumericConst(parent.getOwner(), 2), child1});
                        break;
                    }
                    case '*': {
                        parent = parent.getOwner().getFunctions().factorProgramNode("^", parent.getOwner(), new ProgramNode[]{child1, this.createNumericConst(parent.getOwner(), 2)});
                        break;
                    }
                    case '/': {
                        parent = this.createNumericConst(parent.getOwner(), 1);
                    }
                }
            }
        }
        return parent;
    }

    private ProgramNode tryZeroDiv(ProgramNode parent) {
        if (parent.getTemplate() == StandardExtensions.EXTENSION_DIV) {
            ProgramNode child1 = parent.getChildNode(0);
            ProgramNode child2 = parent.getChildNode(1);
            if (!this.isConstValue(child2, 0.0) && this.isConstValue(child1, 0.0)) {
                this.rewritten = true;
                return this.createNumericConst(parent.getOwner(), 0);
            }
        }
        return parent;
    }

    private ProgramNode tryZeroMul(ProgramNode parent) {
        if (parent.getTemplate() == StandardExtensions.EXTENSION_MUL) {
            ProgramNode child1 = parent.getChildNode(0);
            ProgramNode child2 = parent.getChildNode(1);
            if (this.isConstValue(child1, 0.0) || this.isConstValue(child2, 0.0)) {
                this.rewritten = true;
                return this.createNumericConst(parent.getOwner(), 0);
            }
        }
        return parent;
    }

    private ProgramNode tryZeroPlus(ProgramNode parent) {
        if (parent.getTemplate() == StandardExtensions.EXTENSION_ADD) {
            ProgramNode child1 = parent.getChildNode(0);
            ProgramNode child2 = parent.getChildNode(1);
            if (this.isConstValue(child1, 0.0)) {
                this.rewritten = true;
                return child2;
            }
            if (this.isConstValue(child2, 0.0)) {
                this.rewritten = true;
                return child1;
            }
        }
        return parent;
    }
}

