/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat;

import java.io.Serializable;
import java.util.Random;
import org.encog.Encog;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.engine.network.activation.ActivationSteepenedSigmoid;
import org.encog.mathutil.randomize.factory.RandomFactory;
import org.encog.ml.MLError;
import org.encog.ml.MLRegression;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.ea.codec.GeneticCODEC;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.population.BasicPopulation;
import org.encog.ml.ea.species.BasicSpecies;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.hyperneat.FactorHyperNEATGenome;
import org.encog.neural.hyperneat.HyperNEATCODEC;
import org.encog.neural.hyperneat.HyperNEATGenome;
import org.encog.neural.hyperneat.substrate.Substrate;
import org.encog.neural.neat.FactorNEATGenome;
import org.encog.neural.neat.NEATCODEC;
import org.encog.neural.neat.NEATGenomeFactory;
import org.encog.neural.neat.NEATNetwork;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.neural.neat.training.NEATInnovationList;
import org.encog.util.identity.BasicGenerateID;
import org.encog.util.identity.GenerateID;
import org.encog.util.obj.ChooseObject;

public class NEATPopulation
extends BasicPopulation
implements Serializable,
MLError,
MLRegression {
    public static final double DEFAULT_SURVIVAL_RATE = 0.2;
    public static final String PROPERTY_NEAT_ACTIVATION = "neatAct";
    public static final String PROPERTY_POPULATION_SIZE = "populationSize";
    public static final String PROPERTY_SURVIVAL_RATE = "survivalRate";
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_CYCLES = 4;
    public static final String PROPERTY_CYCLES = "cycles";
    public static final double DEFAULT_NEAT_WEIGHT_RANGE = 1.0;
    public static final double DEFAULT_HYPERNEAT_WEIGHT_RANGE = 5.0;
    private int activationCycles = 4;
    private final GenerateID geneIDGenerate = new BasicGenerateID();
    private final GenerateID innovationIDGenerate = new BasicGenerateID();
    private NEATInnovationList innovations;
    private double weightRange = 1.0;
    private Genome cachedBestGenome;
    private NEATNetwork bestNetwork;
    int inputCount;
    int outputCount;
    private double survivalRate = 0.2;
    private Substrate substrate;
    private final ChooseObject<ActivationFunction> activationFunctions = new ChooseObject();
    private GeneticCODEC codec;
    private double initialConnectionDensity = 0.1;
    private RandomFactory randomNumberFactory = Encog.getInstance().getRandomFactory().factorFactory();

    public static double clampWeight(double w, double weightRange) {
        if (w < -weightRange) {
            return -weightRange;
        }
        if (w > weightRange) {
            return weightRange;
        }
        return w;
    }

    public NEATPopulation() {
    }

    public NEATPopulation(int inputCount, int outputCount, int populationSize) {
        super(populationSize, null);
        this.inputCount = inputCount;
        this.outputCount = outputCount;
        this.setNEATActivationFunction(new ActivationSteepenedSigmoid());
        if (populationSize == 0) {
            throw new NeuralNetworkError("Population must have more than zero genomes.");
        }
    }

    public NEATPopulation(Substrate theSubstrate, int populationSize) {
        super(populationSize, new FactorHyperNEATGenome());
        this.substrate = theSubstrate;
        this.inputCount = 6;
        this.outputCount = 2;
        this.weightRange = 5.0;
        HyperNEATGenome.buildCPPNActivationFunctions(this.activationFunctions);
    }

    public long assignGeneID() {
        return this.geneIDGenerate.generate();
    }

    public long assignInnovationID() {
        return this.innovationIDGenerate.generate();
    }

    @Override
    public double calculateError(MLDataSet data) {
        this.updateBestNetwork();
        if (this.bestNetwork == null) {
            return Double.POSITIVE_INFINITY;
        }
        return this.bestNetwork.calculateError(data);
    }

    @Override
    public MLData compute(MLData input) {
        this.updateBestNetwork();
        return this.bestNetwork.compute(input);
    }

    public int getActivationCycles() {
        return this.activationCycles;
    }

    public ChooseObject<ActivationFunction> getActivationFunctions() {
        return this.activationFunctions;
    }

    public GeneticCODEC getCODEC() {
        return this.codec;
    }

    public GenerateID getGeneIDGenerate() {
        return this.geneIDGenerate;
    }

    @Override
    public NEATGenomeFactory getGenomeFactory() {
        return (NEATGenomeFactory)super.getGenomeFactory();
    }

    public double getInitialConnectionDensity() {
        return this.initialConnectionDensity;
    }

    public GenerateID getInnovationIDGenerate() {
        return this.innovationIDGenerate;
    }

    public NEATInnovationList getInnovations() {
        return this.innovations;
    }

    @Override
    public int getInputCount() {
        return this.inputCount;
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    public RandomFactory getRandomNumberFactory() {
        return this.randomNumberFactory;
    }

    public Substrate getSubstrate() {
        return this.substrate;
    }

    public double getSurvivalRate() {
        return this.survivalRate;
    }

    public double getWeightRange() {
        return this.weightRange;
    }

    public boolean isHyperNEAT() {
        return this.substrate != null;
    }

    public void reset() {
        if (this.isHyperNEAT()) {
            this.codec = new HyperNEATCODEC();
            this.setGenomeFactory(new FactorHyperNEATGenome());
        } else {
            this.codec = new NEATCODEC();
            this.setGenomeFactory(new FactorNEATGenome());
        }
        this.getSpecies().clear();
        this.getGeneIDGenerate().setCurrentID(1L);
        this.getInnovationIDGenerate().setCurrentID(1L);
        Random rnd = this.randomNumberFactory.factor();
        BasicSpecies defaultSpecies = new BasicSpecies();
        defaultSpecies.setPopulation(this);
        for (int i = 0; i < this.getPopulationSize(); ++i) {
            NEATGenome genome = this.getGenomeFactory().factor(rnd, this, this.inputCount, this.outputCount, this.initialConnectionDensity);
            defaultSpecies.add(genome);
        }
        defaultSpecies.setLeader(defaultSpecies.getMembers().get(0));
        this.getSpecies().add(defaultSpecies);
        this.setInnovations(new NEATInnovationList(this));
    }

    public void setActivationCycles(int activationCycles) {
        this.activationCycles = activationCycles;
    }

    public void setCODEC(GeneticCODEC codec) {
        this.codec = codec;
    }

    public void setInitialConnectionDensity(double initialConnectionDensity) {
        this.initialConnectionDensity = initialConnectionDensity;
    }

    public void setInnovations(NEATInnovationList theInnovations) {
        this.innovations = theInnovations;
    }

    public void setInputCount(int inputCount) {
        this.inputCount = inputCount;
    }

    public void setNEATActivationFunction(ActivationFunction af) {
        this.activationFunctions.clear();
        this.activationFunctions.add(1.0, af);
        this.activationFunctions.finalizeStructure();
    }

    public void setOutputCount(int outputCount) {
        this.outputCount = outputCount;
    }

    public void setRandomNumberFactory(RandomFactory randomNumberFactory) {
        this.randomNumberFactory = randomNumberFactory;
    }

    public void setSubstrate(Substrate substrate) {
        this.substrate = substrate;
    }

    public void setSurvivalRate(double theSurvivalRate) {
        this.survivalRate = theSurvivalRate;
    }

    public void setWeightRange(double weightRange) {
        this.weightRange = weightRange;
    }

    private void updateBestNetwork() {
        if (this.getBestGenome() != this.cachedBestGenome) {
            this.cachedBestGenome = this.getBestGenome();
            this.bestNetwork = (NEATNetwork)this.getCODEC().decode(this.getBestGenome());
        }
    }
}

