/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training.opp;

import java.io.Serializable;
import java.util.List;
import java.util.Random;
import org.encog.ml.ea.genome.Genome;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.neural.neat.training.NEATLinkGene;
import org.encog.neural.neat.training.opp.NEATMutation;
import org.encog.neural.neat.training.opp.links.MutateLinkWeight;
import org.encog.neural.neat.training.opp.links.SelectLinks;

public class NEATMutateWeights
extends NEATMutation
implements Serializable {
    private final SelectLinks linkSelection;
    private final MutateLinkWeight weightMutation;

    public NEATMutateWeights(SelectLinks theLinkSelection, MutateLinkWeight theWeightMutation) {
        this.linkSelection = theLinkSelection;
        this.weightMutation = theWeightMutation;
    }

    public SelectLinks getLinkSelection() {
        return this.linkSelection;
    }

    public MutateLinkWeight getWeightMutation() {
        return this.weightMutation;
    }

    @Override
    public void performOperation(Random rnd, Genome[] parents, int parentIndex, Genome[] offspring, int offspringIndex) {
        NEATGenome target = this.obtainGenome(parents, parentIndex, offspring, offspringIndex);
        double weightRange = ((NEATPopulation)this.getOwner().getPopulation()).getWeightRange();
        List<NEATLinkGene> list = this.linkSelection.selectLinks(rnd, target);
        for (NEATLinkGene gene : list) {
            this.weightMutation.mutateWeight(rnd, gene, weightRange);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        result.append(this.getClass().getSimpleName());
        result.append(":sel=");
        result.append(this.linkSelection.toString());
        result.append(",mutate=");
        result.append(this.weightMutation.toString());
        result.append("]");
        return result.toString();
    }
}

