/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training.opp;

import java.io.Serializable;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.ml.ea.genome.Genome;
import org.encog.ml.ea.opp.EvolutionaryOperator;
import org.encog.ml.ea.train.EvolutionaryAlgorithm;
import org.encog.neural.neat.NEATNeuronType;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.neat.training.NEATGenome;
import org.encog.neural.neat.training.NEATInnovation;
import org.encog.neural.neat.training.NEATLinkGene;
import org.encog.neural.neat.training.NEATNeuronGene;

public abstract class NEATMutation
implements EvolutionaryOperator,
Serializable {
    private EvolutionaryAlgorithm owner;

    public NEATNeuronGene chooseRandomNeuron(NEATGenome target, boolean choosingFrom) {
        int end;
        int ac;
        int start = choosingFrom ? 0 : target.getInputCount() + 1;
        if (!choosingFrom && (ac = ((NEATPopulation)target.getPopulation()).getActivationCycles()) == 1) {
            start += target.getOutputCount();
        }
        if (start > (end = target.getNeuronsChromosome().size() - 1)) {
            return null;
        }
        int neuronPos = RangeRandomizer.randomInt(start, end);
        NEATNeuronGene neuronGene = target.getNeuronsChromosome().get(neuronPos);
        return neuronGene;
    }

    public void createLink(NEATGenome target, long neuron1ID, long neuron2ID, double weight) {
        NEATLinkGene linkGene2;
        for (NEATLinkGene linkGene2 : target.getLinksChromosome()) {
            if (linkGene2.getFromNeuronID() != neuron1ID || linkGene2.getToNeuronID() != neuron2ID) continue;
            linkGene2.setEnabled(true);
            linkGene2.setWeight(weight);
            return;
        }
        NEATInnovation innovation = ((NEATPopulation)target.getPopulation()).getInnovations().findInnovation(neuron1ID, neuron2ID);
        linkGene2 = new NEATLinkGene(neuron1ID, neuron2ID, true, innovation.getInnovationID(), weight);
        target.getLinksChromosome().add(linkGene2);
    }

    public int getElementPos(NEATGenome target, long neuronID) {
        for (int i = 0; i < target.getNeuronsChromosome().size(); ++i) {
            NEATNeuronGene neuronGene = target.getNeuronsChromosome().get(i);
            if (neuronGene.getId() != neuronID) continue;
            return i;
        }
        return -1;
    }

    public EvolutionaryAlgorithm getOwner() {
        return this.owner;
    }

    @Override
    public void init(EvolutionaryAlgorithm theOwner) {
        this.owner = theOwner;
    }

    public boolean isDuplicateLink(NEATGenome target, long fromNeuronID, long toNeuronID) {
        for (NEATLinkGene linkGene : target.getLinksChromosome()) {
            if (!linkGene.isEnabled() || linkGene.getFromNeuronID() != fromNeuronID || linkGene.getToNeuronID() != toNeuronID) continue;
            return true;
        }
        return false;
    }

    public boolean isNeuronNeeded(NEATGenome target, long neuronID) {
        for (NEATNeuronGene nEATNeuronGene : target.getNeuronsChromosome()) {
            NEATNeuronGene neuron;
            if (nEATNeuronGene.getId() != neuronID || (neuron = nEATNeuronGene).getNeuronType() != NEATNeuronType.Input && neuron.getNeuronType() != NEATNeuronType.Bias && neuron.getNeuronType() != NEATNeuronType.Output) continue;
            return true;
        }
        for (NEATLinkGene nEATLinkGene : target.getLinksChromosome()) {
            NEATLinkGene linkGene = nEATLinkGene;
            if (linkGene.getFromNeuronID() == neuronID) {
                return true;
            }
            if (linkGene.getToNeuronID() != neuronID) continue;
            return true;
        }
        return false;
    }

    public NEATGenome obtainGenome(Genome[] parents, int parentIndex, Genome[] offspring, int offspringIndex) {
        offspring[offspringIndex] = this.getOwner().getPopulation().getGenomeFactory().factor(parents[0]);
        return (NEATGenome)offspring[offspringIndex];
    }

    @Override
    public int offspringProduced() {
        return 1;
    }

    @Override
    public int parentsNeeded() {
        return 1;
    }

    public void removeNeuron(NEATGenome target, long neuronID) {
        for (NEATNeuronGene gene : target.getNeuronsChromosome()) {
            if (gene.getId() != neuronID) continue;
            target.getNeuronsChromosome().remove(gene);
            return;
        }
    }
}

