/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training.opp.links;

import java.io.Serializable;
import java.util.Random;
import org.encog.ml.ea.train.EvolutionaryAlgorithm;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.neat.training.NEATLinkGene;
import org.encog.neural.neat.training.opp.links.MutateLinkWeight;

public class MutatePerturbLinkWeight
implements MutateLinkWeight,
Serializable {
    private EvolutionaryAlgorithm trainer;
    private final double sigma;

    public MutatePerturbLinkWeight(double theSigma) {
        this.sigma = theSigma;
    }

    @Override
    public EvolutionaryAlgorithm getTrainer() {
        return this.trainer;
    }

    @Override
    public void init(EvolutionaryAlgorithm theTrainer) {
        this.trainer = theTrainer;
    }

    @Override
    public void mutateWeight(Random rnd, NEATLinkGene linkGene, double weightRange) {
        double delta = rnd.nextGaussian() * this.sigma;
        double w = linkGene.getWeight() + delta;
        w = NEATPopulation.clampWeight(w, weightRange);
        linkGene.setWeight(w);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        result.append(this.getClass().getSimpleName());
        result.append(":sigma=");
        result.append(this.sigma);
        result.append("]");
        return result.toString();
    }
}

