/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training;

import java.io.Serializable;
import org.encog.ml.CalculateScore;
import org.encog.ml.MLMethod;
import org.encog.ml.MLRegression;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.buffer.BufferedMLDataSet;
import org.encog.util.error.CalculateRegressionError;

public class TrainingSetScore
implements CalculateScore,
Serializable {
    private final MLDataSet training;

    public TrainingSetScore(MLDataSet training) {
        this.training = training;
    }

    @Override
    public double calculateScore(MLMethod method) {
        return CalculateRegressionError.calculateError((MLRegression)method, this.training);
    }

    @Override
    public boolean shouldMinimize() {
        return true;
    }

    @Override
    public boolean requireSingleThreaded() {
        return this.training instanceof BufferedMLDataSet;
    }
}

