/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.propagation.sgd.update;

import org.encog.neural.networks.training.propagation.sgd.StochasticGradientDescent;
import org.encog.neural.networks.training.propagation.sgd.update.UpdateRule;

public class MomentumUpdate
implements UpdateRule {
    private StochasticGradientDescent training;
    private double[] lastDelta;

    @Override
    public void init(StochasticGradientDescent theTraining) {
        this.training = theTraining;
        this.lastDelta = new double[theTraining.getFlat().getWeights().length];
    }

    @Override
    public void update(double[] gradients, double[] weights) {
        for (int i = 0; i < weights.length; ++i) {
            double delta = this.training.getLearningRate() * gradients[i] + this.training.getMomentum() * this.lastDelta[i];
            int n = i;
            weights[n] = weights[n] + delta;
            this.lastDelta[i] = delta;
        }
    }
}

