/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.networks.training.propagation.sgd.update;

import org.encog.neural.networks.training.propagation.sgd.StochasticGradientDescent;
import org.encog.neural.networks.training.propagation.sgd.update.UpdateRule;

public class NesterovUpdate
implements UpdateRule {
    private StochasticGradientDescent training;
    private double[] lastDelta;

    @Override
    public void init(StochasticGradientDescent theTraining) {
        this.training = theTraining;
        this.lastDelta = new double[theTraining.getFlat().getWeights().length];
    }

    @Override
    public void update(double[] gradients, double[] weights) {
        int i = 0;
        while (i < weights.length) {
            double prevNesterov = this.lastDelta[i];
            this.lastDelta[i] = this.training.getMomentum() * prevNesterov + gradients[i] * this.training.getLearningRate();
            double delta = this.training.getMomentum() * prevNesterov - (1.0 + this.training.getMomentum()) * this.lastDelta[i];
            int n = i++;
            weights[n] = weights[n] + delta;
        }
    }
}

