/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.rbf;

import org.encog.EncogError;
import org.encog.mathutil.randomize.ConsistentRandomizer;
import org.encog.mathutil.randomize.RangeRandomizer;
import org.encog.mathutil.rbf.GaussianFunction;
import org.encog.mathutil.rbf.InverseMultiquadricFunction;
import org.encog.mathutil.rbf.MultiquadricFunction;
import org.encog.mathutil.rbf.RBFEnum;
import org.encog.mathutil.rbf.RadialBasisFunction;
import org.encog.ml.BasicML;
import org.encog.ml.MLEncodable;
import org.encog.ml.MLError;
import org.encog.ml.MLRegression;
import org.encog.ml.MLResettable;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.neural.NeuralNetworkError;
import org.encog.neural.flat.FlatNetwork;
import org.encog.neural.flat.FlatNetworkRBF;
import org.encog.neural.networks.ContainsFlat;
import org.encog.util.EngineArray;
import org.encog.util.Format;
import org.encog.util.simple.EncogUtility;

public class RBFNetwork
extends BasicML
implements MLError,
MLRegression,
ContainsFlat,
MLResettable,
MLEncodable {
    private static final long serialVersionUID = 1L;
    private final FlatNetworkRBF flat;

    public RBFNetwork() {
        this.flat = new FlatNetworkRBF();
    }

    public RBFNetwork(int inputCount, int hiddenCount, int outputCount, RBFEnum t) {
        if (hiddenCount == 0) {
            throw new NeuralNetworkError("RBF network cannot have zero hidden neurons.");
        }
        RadialBasisFunction[] rbf = new RadialBasisFunction[hiddenCount];
        double volumeNeuronWidth = 2.0 / (double)hiddenCount;
        this.flat = new FlatNetworkRBF(inputCount, rbf.length, outputCount, rbf);
        try {
            this.setRBFCentersAndWidthsEqualSpacing(-1.0, 1.0, t, volumeNeuronWidth, false);
        }
        catch (EncogError ex) {
            this.randomizeRBFCentersAndWidths(-1.0, 1.0, t);
        }
    }

    public RBFNetwork(int inputCount, int outputCount, RadialBasisFunction[] rbf) {
        this.flat = new FlatNetworkRBF(inputCount, rbf.length, outputCount, rbf);
        this.flat.setRBF(rbf);
    }

    @Override
    public double calculateError(MLDataSet data) {
        return EncogUtility.calculateRegressionError(this, data);
    }

    @Override
    public MLData compute(MLData input) {
        BasicMLData output = new BasicMLData(this.getOutputCount());
        this.flat.compute(input.getData(), output.getData());
        return output;
    }

    @Override
    public FlatNetwork getFlat() {
        return this.flat;
    }

    @Override
    public int getInputCount() {
        return this.flat.getInputCount();
    }

    @Override
    public int getOutputCount() {
        return this.flat.getOutputCount();
    }

    public RadialBasisFunction[] getRBF() {
        return this.flat.getRBF();
    }

    public void randomizeRBFCentersAndWidths(double min, double max, RBFEnum t) {
        int i;
        int dimensions = this.getInputCount();
        double[] centers = new double[dimensions];
        for (i = 0; i < dimensions; ++i) {
            centers[i] = RangeRandomizer.randomize(min, max);
        }
        for (i = 0; i < this.flat.getRBF().length; ++i) {
            this.setRBFFunction(i, t, centers, RangeRandomizer.randomize(min, max));
        }
    }

    public void setRBF(RadialBasisFunction[] rbf) {
        this.flat.setRBF(rbf);
    }

    public void setRBFCentersAndWidths(double[][] centers, double[] widths, RBFEnum t) {
        for (int i = 0; i < this.flat.getRBF().length; ++i) {
            this.setRBFFunction(i, t, centers[i], widths[i]);
        }
    }

    public void setRBFCentersAndWidthsEqualSpacing(double minPosition, double maxPosition, RBFEnum t, double volumeNeuronRBFWidth, boolean useWideEdgeRBFs) {
        int totalNumHiddenNeurons = this.flat.getRBF().length;
        int dimensions = this.getInputCount();
        double disMinMaxPosition = Math.abs(maxPosition - minPosition);
        double cmp = Math.pow(totalNumHiddenNeurons, 1.0 / (double)dimensions);
        int expectedSideLength = (int)Math.round(cmp);
        if (Math.round(Math.pow(expectedSideLength, dimensions)) != (long)totalNumHiddenNeurons) {
            throw new NeuralNetworkError("Total number of RBF neurons must be some integer to the power of 'dimensions'.\n" + Format.formatDouble(expectedSideLength, 5) + " <> " + Format.formatDouble(cmp, 5));
        }
        double edgeNeuronRBFWidth = 2.5 * volumeNeuronRBFWidth;
        double[][] centers = new double[totalNumHiddenNeurons][];
        double[] widths = new double[totalNumHiddenNeurons];
        for (int i = 0; i < totalNumHiddenNeurons; ++i) {
            centers[i] = new double[dimensions];
            int sideLength = expectedSideLength;
            int temp = i;
            for (int j = dimensions; j > 0; --j) {
                centers[i][j - 1] = (double)((int)((double)temp / Math.pow(sideLength, j - 1))) * (disMinMaxPosition / (double)(sideLength - 1)) + minPosition;
                temp %= (int)Math.pow(sideLength, j - 1);
            }
            boolean contains = false;
            for (int z = 0; z < centers[0].length; ++z) {
                if (centers[i][z] != 1.0 && centers[i][z] != 0.0) continue;
                contains = true;
            }
            widths[i] = contains && useWideEdgeRBFs ? edgeNeuronRBFWidth : volumeNeuronRBFWidth;
        }
        this.setRBFCentersAndWidths(centers, widths, t);
    }

    public void setRBFFunction(int index, RBFEnum t, double[] centers, double width) {
        if (t == RBFEnum.Gaussian) {
            this.flat.getRBF()[index] = new GaussianFunction(0.5, centers, width);
        } else if (t == RBFEnum.Multiquadric) {
            this.flat.getRBF()[index] = new MultiquadricFunction(0.5, centers, width);
        } else if (t == RBFEnum.InverseMultiquadric) {
            this.flat.getRBF()[index] = new InverseMultiquadricFunction(0.5, centers, width);
        }
    }

    @Override
    public void updateProperties() {
    }

    @Override
    public void reset() {
        new RangeRandomizer(-1.0, 1.0).randomize(this);
    }

    @Override
    public void reset(int seed) {
        ConsistentRandomizer randomizer = new ConsistentRandomizer(-1.0, 1.0, seed);
        randomizer.randomize(this);
    }

    @Override
    public int encodedArrayLength() {
        int result = this.getFlat().getWeights().length;
        for (RadialBasisFunction rbf : this.flat.getRBF()) {
            result += rbf.getCenters().length + 1;
        }
        return result;
    }

    @Override
    public void encodeToArray(double[] encoded) {
        EngineArray.arrayCopy(this.getFlat().getWeights(), 0, encoded, 0, this.getFlat().getWeights().length);
        int index = this.getFlat().getWeights().length;
        for (RadialBasisFunction rbf : this.flat.getRBF()) {
            encoded[index++] = rbf.getWidth();
            EngineArray.arrayCopy(rbf.getCenters(), 0, encoded, index, rbf.getCenters().length);
            index += rbf.getCenters().length;
        }
    }

    @Override
    public void decodeFromArray(double[] encoded) {
        EngineArray.arrayCopy(encoded, 0, this.getFlat().getWeights(), 0, this.getFlat().getWeights().length);
        int index = this.getFlat().getWeights().length;
        for (RadialBasisFunction rbf : this.flat.getRBF()) {
            rbf.setWidth(encoded[index++]);
            EngineArray.arrayCopy(encoded, index, rbf.getCenters(), 0, rbf.getCenters().length);
            index += rbf.getCenters().length;
        }
    }
}

