/*
 * Decompiled with CFR 0.152.
 */
package org.encog.persist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.encog.app.analyst.AnalystError;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.mathutil.matrices.Matrix;
import org.encog.persist.PersistError;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.NumberList;
import org.encog.util.csv.ParseCSVLine;

public class EncogFileSection {
    private List<double[]> largeArrays = new ArrayList<double[]>();
    private final String sectionName;
    private final String subSectionName;
    private final List<String> lines = new ArrayList<String>();

    public static ActivationFunction parseActivationFunction(String value) {
        ActivationFunction af = null;
        String[] cols = value.split("\\|");
        String afName = "org.encog.engine.network.activation." + cols[0];
        try {
            Class<?> clazz = Class.forName(afName);
            af = (ActivationFunction)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new PersistError(e);
        }
        catch (InstantiationException e) {
            throw new PersistError(e);
        }
        catch (IllegalAccessException e) {
            throw new PersistError(e);
        }
        for (int i = 0; i < af.getParamNames().length; ++i) {
            af.setParam(i, CSVFormat.EG_FORMAT.parse(cols[i + 1]));
        }
        return af;
    }

    public static ActivationFunction parseActivationFunction(Map<String, String> params, String name) {
        String value = null;
        try {
            value = params.get(name);
            if (value == null) {
                throw new PersistError("Missing property: " + name);
            }
            return EncogFileSection.parseActivationFunction(value);
        }
        catch (Exception ex) {
            throw new PersistError(ex);
        }
    }

    public static boolean parseBoolean(Map<String, String> params, String name) {
        String value = null;
        try {
            value = params.get(name);
            if (value == null) {
                throw new PersistError("Missing property: " + name);
            }
            return value.trim().toLowerCase().charAt(0) == 't';
        }
        catch (NumberFormatException ex) {
            throw new PersistError("Field: " + name + ", invalid integer: " + value);
        }
    }

    public static double parseDouble(Map<String, String> params, String name) {
        String value = null;
        try {
            value = params.get(name);
            if (value == null) {
                throw new PersistError("Missing property: " + name);
            }
            return CSVFormat.EG_FORMAT.parse(value);
        }
        catch (NumberFormatException ex) {
            throw new PersistError("Field: " + name + ", invalid integer: " + value);
        }
    }

    public double[] parseDoubleArray(Map<String, String> params, String name) {
        String value = null;
        try {
            value = params.get(name);
            if (value == null) {
                throw new PersistError("Missing property: " + name);
            }
            if (value.startsWith("##")) {
                int i = Integer.parseInt(value.substring(2));
                return this.largeArrays.get(i);
            }
            return NumberList.fromList(CSVFormat.EG_FORMAT, value);
        }
        catch (NumberFormatException ex) {
            throw new PersistError("Field: " + name + ", invalid integer: " + value);
        }
    }

    public static int parseInt(Map<String, String> params, String name) {
        String value = null;
        try {
            value = params.get(name);
            if (value == null) {
                throw new PersistError("Missing property: " + name);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new PersistError("Field: " + name + ", invalid integer: " + value);
        }
    }

    public static int[] parseIntArray(Map<String, String> params, String name) {
        String value = null;
        try {
            value = params.get(name);
            if (value == null) {
                throw new PersistError("Missing property: " + name);
            }
            return NumberList.fromListInt(CSVFormat.EG_FORMAT, value);
        }
        catch (NumberFormatException ex) {
            throw new PersistError("Field: " + name + ", invalid integer: " + value);
        }
    }

    public static Matrix parseMatrix(Map<String, String> params, String name) {
        if (!params.containsKey(name)) {
            throw new PersistError("Missing property: " + name);
        }
        String line = params.get(name);
        double[] d = NumberList.fromList(CSVFormat.EG_FORMAT, line);
        int rows = (int)d[0];
        int cols = (int)d[1];
        Matrix result = new Matrix(rows, cols);
        int index = 2;
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                result.set(r, c, d[index++]);
            }
        }
        return result;
    }

    public static List<String> splitColumns(String line) {
        ParseCSVLine csvLine = new ParseCSVLine(CSVFormat.EG_FORMAT);
        return csvLine.parse(line);
    }

    public EncogFileSection(String theSectionName, String theSubSectionName) {
        this.sectionName = theSectionName;
        this.subSectionName = theSubSectionName;
    }

    public final List<String> getLines() {
        return this.lines;
    }

    public final String getLinesAsString() {
        StringBuilder result = new StringBuilder();
        for (String line : this.lines) {
            result.append(line);
            result.append("\n");
        }
        return result.toString();
    }

    public final String getSectionName() {
        return this.sectionName;
    }

    public final String getSubSectionName() {
        return this.subSectionName;
    }

    public final Map<String, String> parseParams() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String line : this.lines) {
            if ((line = line.trim()).length() <= 0) continue;
            int idx = line.indexOf(61);
            if (idx == -1) {
                throw new AnalystError("Invalid setup item: " + line);
            }
            String name = line.substring(0, idx).trim();
            String value = line.substring(idx + 1).trim();
            result.put(name, value);
        }
        return result;
    }

    public final String toString() {
        StringBuilder result = new StringBuilder("[");
        result.append(this.getClass().getSimpleName());
        result.append(" sectionName=");
        result.append(this.sectionName);
        result.append(", subSectionName=");
        result.append(this.subSectionName);
        result.append("]");
        return result.toString();
    }

    public List<double[]> getLargeArrays() {
        return this.largeArrays;
    }

    public void setLargeArrays(List<double[]> largeArrays) {
        this.largeArrays = largeArrays;
    }
}

