/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class EngineArray {
    public static double[] arrayCopy(double[] input) {
        double[] result = new double[input.length];
        EngineArray.arrayCopy(input, result);
        return result;
    }

    public static byte[] arrayCopy(byte[] input) {
        byte[] result = new byte[input.length];
        EngineArray.arrayCopy(input, result);
        return result;
    }

    private static void arrayCopy(byte[] src, byte[] dst) {
        System.arraycopy(src, 0, dst, 0, src.length);
    }

    public static void arrayCopy(double[] src, double[] dst) {
        System.arraycopy(src, 0, dst, 0, src.length);
    }

    public static void arrayCopy(double[] source, float[] target) {
        for (int i = 0; i < source.length; ++i) {
            target[i] = (float)source[i];
        }
    }

    public static void arrayCopy(double[] source, int sourcePos, double[] target, int targetPos, int length) {
        System.arraycopy(source, sourcePos, target, targetPos, length);
    }

    public static double[][] arrayCopy(double[][] source) {
        double[][] result = new double[source.length][source[0].length];
        for (int row = 0; row < source.length; ++row) {
            System.arraycopy(source[row], 0, result[row], 0, source[0].length);
        }
        return result;
    }

    public static void arrayCopy(float[] source, double[] target) {
        for (int i = 0; i < source.length; ++i) {
            target[i] = source[i];
        }
    }

    public static int[] arrayCopy(int[] input) {
        int[] result = new int[input.length];
        EngineArray.arrayCopy(input, result);
        return result;
    }

    public static void arrayCopy(int[] src, int[] dst) {
        System.arraycopy(src, 0, dst, 0, src.length);
    }

    public static Double[] doubleToObject(double[] array) {
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Double(array[i]);
        }
        return result;
    }

    public static void fill(double[] array, double value) {
        Arrays.fill(array, value);
    }

    public static void fill(float[] array, float value) {
        Arrays.fill(array, value);
    }

    public static int findStringInArray(String[] search, String searchFor) {
        for (int i = 0; i < search.length; ++i) {
            if (!search[i].equals(searchFor)) continue;
            return i;
        }
        return -1;
    }

    public static double[] listToDouble(Collection<?> list) {
        double[] result = new double[list.size()];
        int index = 0;
        for (Object obj : list) {
            result[index++] = (Double)obj;
        }
        return result;
    }

    public static double[] objectToDouble(Double[] array) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = new Double(array[i]);
        }
        return result;
    }

    public static double vectorProduct(double[] a, double[] b) {
        int length = a.length;
        double value = 0.0;
        for (int i = 0; i < length; ++i) {
            value += a[i] * b[i];
        }
        return value;
    }

    private EngineArray() {
    }

    public static int indexOfLargest(double[] data) {
        int result = -1;
        for (int i = 0; i < data.length; ++i) {
            if (result != -1 && !(data[i] > data[result])) continue;
            result = i;
        }
        return result;
    }

    public static double min(double[] weights) {
        double result = Double.MAX_VALUE;
        for (int i = 0; i < weights.length; ++i) {
            result = Math.min(result, weights[i]);
        }
        return result;
    }

    public static double max(double[] weights) {
        double result = Double.MIN_VALUE;
        for (int i = 0; i < weights.length; ++i) {
            result = Math.max(result, weights[i]);
        }
        return result;
    }

    public static boolean contains(int[] array, int target) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != target) continue;
            return true;
        }
        return false;
    }

    public static int maxIndex(double[] data) {
        int result = -1;
        for (int i = 0; i < data.length; ++i) {
            if (result != -1 && !(data[i] > data[result])) continue;
            result = i;
        }
        return result;
    }

    public static int maxIndex(int[] data) {
        int result = -1;
        for (int i = 0; i < data.length; ++i) {
            if (result != -1 && data[i] <= data[result]) continue;
            result = i;
        }
        return result;
    }

    public static int max(int[] data) {
        int result = Integer.MIN_VALUE;
        for (int i = 0; i < data.length; ++i) {
            result = Math.max(result, data[i]);
        }
        return result;
    }

    public static int min(int[] data) {
        int result = Integer.MAX_VALUE;
        for (int i = 0; i < data.length; ++i) {
            result = Math.min(result, data[i]);
        }
        return result;
    }

    public static double mean(int[] data) {
        double result = 0.0;
        for (int i = 0; i < data.length; ++i) {
            result += (double)data[i];
        }
        return result / (double)data.length;
    }

    public static double sdev(int[] data) {
        double avg = EngineArray.mean(data);
        double result = 0.0;
        for (int i = 0; i < data.length; ++i) {
            double diff = (double)data[i] - avg;
            result += diff * diff;
        }
        return Math.sqrt(result / (double)data.length);
    }

    public static double euclideanDistance(double[] p1, double[] p2) {
        double sum = 0.0;
        for (int i = 0; i < p1.length; ++i) {
            double d = p1[i] - p2[i];
            sum += d * d;
        }
        return Math.sqrt(sum);
    }

    public static void fill(double[][] sigma, int value) {
        for (int i = 0; i < sigma.length; ++i) {
            for (int j = 0; j < sigma[i].length; ++j) {
                sigma[i][j] = value;
            }
        }
    }

    public static void fill(boolean[] a, boolean b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = b;
        }
    }

    public static double[] add(double[] d, double[] m) {
        double[] result = new double[d.length];
        for (int i = 0; i < d.length; ++i) {
            result[i] = d[i] + m[i];
        }
        return result;
    }

    public static double[] subtract(double[] a, double[] b) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] - b[i];
        }
        return result;
    }

    public static double mean(double[] data) {
        double result = 0.0;
        for (int i = 0; i < data.length; ++i) {
            result += data[i];
        }
        return result / (double)data.length;
    }

    public static void fill(int[] a, int value) {
        Arrays.fill(a, value);
    }

    public static String replace(String str, String searchFor, String replace) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            String cmp;
            boolean append = true;
            if (i + searchFor.length() < str.length() && (cmp = str.substring(i, i + searchFor.length())).equals(searchFor)) {
                i += searchFor.length() - 1;
                result.append(replace);
                append = false;
            }
            if (!append) continue;
            result.append(str.charAt(i));
        }
        return result.toString();
    }

    public static void arrayCopy(byte[] source, int sourcePos, byte[] target, int targetPos, int length) {
        System.arraycopy(source, sourcePos, target, targetPos, length);
    }

    public static void arrayCopy(int[] source, int sourcePos, int[] target, int targetPos, int length) {
        System.arraycopy(source, sourcePos, target, targetPos, length);
    }

    public static void arrayAdd(double[][] target, double[][] h) {
        for (int row = 0; row < target.length; ++row) {
            for (int col = 0; col < target[row].length; ++col) {
                double[] dArray = target[row];
                int n = col;
                dArray[n] = dArray[n] + h[row][col];
            }
        }
    }

    public static List<String> string2list(String str) {
        String[] list;
        if (str == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String s : list = str.split(",")) {
            if (s.length() <= 0) continue;
            result.add(s);
        }
        return result;
    }

    public static String list2string(List<String> list) {
        StringBuilder result = new StringBuilder();
        for (String str : list) {
            if (result.length() != 0) {
                result.append(',');
            }
            result.append(str);
        }
        return result.toString();
    }
}

