/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util;

import org.encog.util.Format;

public class Stopwatch {
    private boolean stopped;
    private long startTime;
    private long stopTime;

    public Stopwatch() {
        this.reset();
        this.stopped = false;
    }

    public long getElapsedMilliseconds() {
        return this.getElapsedTicks() / 1000L;
    }

    public long getElapsedTicks() {
        if (!this.stopped) {
            this.stopTime = System.nanoTime();
        }
        return (this.stopTime - this.startTime) / 1000L;
    }

    public void reset() {
        this.startTime = System.nanoTime();
        this.stopTime = System.nanoTime();
        this.stopped = false;
    }

    public void start() {
        this.startTime = System.nanoTime();
        this.stopped = false;
    }

    public void stop() {
        this.stopTime = System.nanoTime();
        this.stopped = true;
    }

    public String toString() {
        return Format.formatTimeSpan((int)(this.getElapsedMilliseconds() / 1000L));
    }
}

