/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.benchmark;

import org.encog.mathutil.randomize.generate.LinearCongruentialRandom;
import org.encog.ml.data.MLDataSet;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.ml.data.basic.BasicMLDataPair;
import org.encog.ml.data.basic.BasicMLDataSet;

public final class RandomTrainingFactory {
    public static BasicMLDataSet generate(long seed, int count, int inputCount, int idealCount, double min, double max) {
        LinearCongruentialRandom rand = new LinearCongruentialRandom(seed);
        BasicMLDataSet result = new BasicMLDataSet();
        for (int i = 0; i < count; ++i) {
            BasicMLData inputData = new BasicMLData(inputCount);
            for (int j = 0; j < inputCount; ++j) {
                inputData.setData(j, rand.nextDouble(min, max));
            }
            BasicMLData idealData = new BasicMLData(idealCount);
            for (int j = 0; j < idealCount; ++j) {
                idealData.setData(j, rand.nextDouble(min, max));
            }
            BasicMLDataPair pair = new BasicMLDataPair(inputData, idealData);
            result.add(pair);
        }
        return result;
    }

    public static void generate(MLDataSet training, long seed, int count, double min, double max) {
        LinearCongruentialRandom rand = new LinearCongruentialRandom(seed);
        int inputCount = training.getInputSize();
        int idealCount = training.getIdealSize();
        for (int i = 0; i < count; ++i) {
            BasicMLData inputData = new BasicMLData(inputCount);
            for (int j = 0; j < inputCount; ++j) {
                inputData.setData(j, rand.nextDouble(min, max));
            }
            BasicMLData idealData = new BasicMLData(idealCount);
            for (int j = 0; j < idealCount; ++j) {
                idealData.setData(j, rand.nextDouble(min, max));
            }
            BasicMLDataPair pair = new BasicMLDataPair(inputData, idealData);
            training.add(pair);
        }
    }

    private RandomTrainingFactory() {
    }
}

