/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.kmeans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.encog.util.kmeans.Centroid;
import org.encog.util.kmeans.CentroidFactory;
import org.encog.util.kmeans.Cluster;

public class KMeansUtil<K extends CentroidFactory<? super K>> {
    private final ArrayList<Cluster<K>> clusters;
    private final int k;

    public KMeansUtil(int theK, List<? extends K> theElements) {
        this.k = theK;
        this.clusters = new ArrayList(theK);
        this.initRandomClusters(theElements);
    }

    private void initRandomClusters(List<? extends K> elements) {
        for (int i = 0; i < this.k; ++i) {
            this.clusters.add(new Cluster());
        }
        int amountLeft = elements.size();
        int place = -1;
        for (CentroidFactory e : elements) {
            if (amountLeft-- == this.k) {
                place = 0;
            }
            if (place >= 0) {
                while (place < this.clusters.size()) {
                    Cluster<K> c = this.clusters.get(place);
                    if (c.getContents().isEmpty()) {
                        c.add(e);
                        break;
                    }
                    ++place;
                }
                if (place != this.clusters.size()) continue;
                place = -1;
            }
            this.clusters.get((int)Math.floor(Math.random() * (double)this.k)).add(e);
        }
    }

    public void process() {
        int i;
        ArrayList newclusters = new ArrayList();
        for (i = 0; i < this.k; ++i) {
            newclusters.add(new Cluster());
        }
        for (i = 0; i < this.k; ++i) {
            Cluster<K> cluster = this.clusters.get(i);
            List<K> thisElements = cluster.getContents();
            for (int j = 0; j < thisElements.size(); ++j) {
                CentroidFactory thisElement = (CentroidFactory)thisElements.get(j);
                int nearestCluster = this.nearestClusterIndex(thisElement);
                ((Cluster)newclusters.get(nearestCluster)).add(thisElement);
            }
        }
        this.clusters.clear();
        for (Cluster cluster : newclusters) {
            this.clusters.add(cluster);
        }
    }

    private Cluster<K> nearestCluster(K element) {
        return this.clusters.get(this.nearestClusterIndex(element));
    }

    private int nearestClusterIndex(K element) {
        double distance = Double.MAX_VALUE;
        int result = -1;
        for (int i = 0; i < this.clusters.size(); ++i) {
            double thisDistance;
            Centroid<K> c = this.clusters.get(i).centroid();
            if (null == c || !(distance > (thisDistance = c.distance(element)))) continue;
            distance = thisDistance;
            result = i;
        }
        return result;
    }

    public Collection<K> get(int index) {
        return this.clusters.get(index).getContents();
    }

    public int size() {
        return this.clusters.size();
    }

    public Cluster<K> getCluster(int i) {
        return this.clusters.get(i);
    }
}

