/*
 * Decompiled with CFR 0.152.
 */
package org.encog.util.normalize;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.encog.NullStatusReportable;
import org.encog.StatusReportable;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataPair;
import org.encog.ml.data.basic.BasicMLData;
import org.encog.neural.data.NeuralDataSet;
import org.encog.util.csv.CSVFormat;
import org.encog.util.csv.ReadCSV;
import org.encog.util.normalize.NormalizationError;
import org.encog.util.normalize.input.HasFixedLength;
import org.encog.util.normalize.input.InputField;
import org.encog.util.normalize.input.InputFieldCSV;
import org.encog.util.normalize.input.InputFieldCSVText;
import org.encog.util.normalize.input.InputFieldMLDataSet;
import org.encog.util.normalize.input.MLDataFieldHolder;
import org.encog.util.normalize.output.OutputField;
import org.encog.util.normalize.output.OutputFieldGroup;
import org.encog.util.normalize.output.OutputFieldGrouped;
import org.encog.util.normalize.output.RequireTwoPass;
import org.encog.util.normalize.segregate.Segregator;
import org.encog.util.normalize.target.NormalizationStorage;
import org.encog.util.obj.ReflectionUtil;

public class DataNormalization
implements Serializable {
    private static final long serialVersionUID = 4387885013771660300L;
    private final List<InputField> inputFields = new ArrayList<InputField>();
    private final List<OutputField> outputFields = new ArrayList<OutputField>();
    private transient Collection<ReadCSV> readCSV;
    private transient Map<InputField, ReadCSV> csvMap;
    private transient Collection<Iterator<MLDataPair>> readDataSet;
    private transient Map<InputField, MLDataFieldHolder> dataSetFieldMap;
    private transient Map<Iterator<MLDataPair>, MLDataFieldHolder> dataSetIteratorMap;
    private final Set<OutputFieldGroup> groups = new HashSet<OutputFieldGroup>();
    private final List<Segregator> segregators = new ArrayList<Segregator>();
    private NormalizationStorage storage;
    private transient StatusReportable report = new NullStatusReportable();
    private int recordCount;
    private int currentIndex;
    private CSVFormat csvFormat = CSVFormat.ENGLISH;
    private int lastReport;

    public void addInputField(InputField f) {
        this.inputFields.add(f);
    }

    public void addOutputField(OutputField outputField) {
        this.addOutputField(outputField, false);
    }

    public void addOutputField(OutputField outputField, boolean ideal) {
        this.outputFields.add(outputField);
        outputField.setIdeal(ideal);
        if (outputField instanceof OutputFieldGrouped) {
            OutputFieldGrouped ofg = (OutputFieldGrouped)outputField;
            this.groups.add(ofg.getGroup());
        }
    }

    public void addSegregator(Segregator segregator) {
        this.segregators.add(segregator);
        segregator.init(this);
    }

    private void applyMinMax() {
        for (InputField field : this.inputFields) {
            double value = field.getCurrentValue();
            field.applyMinMax(value);
        }
    }

    public MLData buildForNetworkInput(double[] data) {
        int index = 0;
        for (InputField inputField : this.inputFields) {
            if (!inputField.getUsedForNetworkInput()) continue;
            if (index >= data.length) {
                throw new NormalizationError("Can't build data, input fields used for neural input, must match provided data(" + data.length + ").");
            }
            inputField.setCurrentValue(data[index++]);
        }
        int outputCount = 0;
        for (OutputField ofield : this.outputFields) {
            if (ofield.isIdeal()) continue;
            for (int sub = 0; sub < ofield.getSubfieldCount(); ++sub) {
                ++outputCount;
            }
        }
        this.initForOutput();
        BasicMLData basicMLData = new BasicMLData(outputCount);
        int outputIndex = 0;
        for (OutputField ofield : this.outputFields) {
            if (ofield.isIdeal()) continue;
            for (int sub = 0; sub < ofield.getSubfieldCount(); ++sub) {
                basicMLData.setData(outputIndex++, ofield.calculate(sub));
            }
        }
        return basicMLData;
    }

    private double determineInputFieldValue(InputField field, int index) {
        double result = 0.0;
        if (field instanceof InputFieldCSVText) {
            InputFieldCSVText fieldCSV = (InputFieldCSVText)field;
            ReadCSV csv = this.csvMap.get(field);
            String v = csv.get(fieldCSV.getOffset());
            if (!fieldCSV.getMappings().containsKey(v)) {
                throw new NormalizationError("Undefined class value: " + v);
            }
            result = fieldCSV.getMappings().get(v).intValue();
        } else if (field instanceof InputFieldCSV) {
            InputFieldCSV fieldCSV = (InputFieldCSV)field;
            ReadCSV csv = this.csvMap.get(field);
            result = csv.getDouble(fieldCSV.getOffset());
        } else if (field instanceof InputFieldMLDataSet) {
            InputFieldMLDataSet neuralField = (InputFieldMLDataSet)field;
            MLDataFieldHolder holder = this.dataSetFieldMap.get(field);
            MLDataPair pair = holder.getPair();
            int offset = neuralField.getOffset();
            result = offset < pair.getInput().size() ? pair.getInput().getData(offset) : pair.getIdeal().getData(offset -= pair.getInput().size());
        } else {
            result = field.getValue(index);
        }
        field.setCurrentValue(result);
        return result;
    }

    private void determineInputFieldValues(int index) {
        for (InputField field : this.inputFields) {
            this.determineInputFieldValue(field, index);
        }
    }

    public InputField findInputField(Class<?> clazz, int count) {
        int i = 0;
        for (InputField field : this.inputFields) {
            if (!ReflectionUtil.isInstanceOf(field.getClass(), clazz)) continue;
            if (i == count) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public OutputField findOutputField(Class<?> clazz, int count) {
        int i = 0;
        for (OutputField field : this.outputFields) {
            if (!ReflectionUtil.isInstanceOf(field.getClass(), clazz)) continue;
            if (i == count) {
                return field;
            }
            ++i;
        }
        return null;
    }

    private void firstPass() {
        this.openCSV();
        this.openDataSet();
        this.currentIndex = -1;
        this.recordCount = 0;
        this.report.report(0, 0, "Analyzing file");
        this.lastReport = 0;
        int index = 0;
        this.initForPass();
        while (this.next()) {
            this.determineInputFieldValues(index);
            if (this.shouldInclude()) {
                this.applyMinMax();
                ++this.recordCount;
                this.reportResult("First pass, analyzing file", 0, this.recordCount);
            }
            ++index;
        }
    }

    public CSVFormat getCSVFormat() {
        return this.csvFormat;
    }

    public Set<OutputFieldGroup> getGroups() {
        return this.groups;
    }

    public List<InputField> getInputFields() {
        return this.inputFields;
    }

    public int getNetworkInputLayerSize() {
        int result = 0;
        for (OutputField field : this.outputFields) {
            if (field.isIdeal()) continue;
            result += field.getSubfieldCount();
        }
        return result;
    }

    public int getNetworkOutputLayerSize() {
        int result = 0;
        for (OutputField field : this.outputFields) {
            if (!field.isIdeal()) continue;
            result += field.getSubfieldCount();
        }
        return result;
    }

    public int getOutputFieldCount() {
        int result = 0;
        for (OutputField field : this.outputFields) {
            result += field.getSubfieldCount();
        }
        return result;
    }

    public List<OutputField> getOutputFields() {
        return this.outputFields;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public StatusReportable getReport() {
        return this.report;
    }

    public List<Segregator> getSegregators() {
        return this.segregators;
    }

    public NormalizationStorage getStorage() {
        return this.storage;
    }

    public void initForOutput() {
        for (OutputFieldGroup group : this.groups) {
            group.rowInit();
        }
        for (OutputField field : this.outputFields) {
            field.rowInit();
        }
    }

    public void initForPass() {
        for (Segregator segregator : this.segregators) {
            segregator.passInit();
        }
    }

    private boolean next() {
        for (ReadCSV readCSV : this.readCSV) {
            if (readCSV.next()) continue;
            return false;
        }
        for (Iterator iterator : this.readDataSet) {
            if (!iterator.hasNext()) {
                return false;
            }
            MLDataFieldHolder holder = this.dataSetIteratorMap.get(iterator);
            MLDataPair pair = (MLDataPair)iterator.next();
            holder.setPair(pair);
        }
        for (InputField inputField : this.inputFields) {
            HasFixedLength fixed;
            if (!(inputField instanceof HasFixedLength) || this.currentIndex + 1 < (fixed = (HasFixedLength)((Object)inputField)).length()) continue;
            return false;
        }
        ++this.currentIndex;
        return true;
    }

    private void openCSV() {
        this.csvMap.clear();
        this.readCSV.clear();
        HashMap<File, ReadCSV> uniqueFiles = new HashMap<File, ReadCSV>();
        for (InputField field : this.inputFields) {
            if (!(field instanceof InputFieldCSV)) continue;
            InputFieldCSV csvField = (InputFieldCSV)field;
            File file = csvField.getFile();
            if (!uniqueFiles.containsKey(file)) {
                ReadCSV csv = new ReadCSV(file.toString(), false, this.csvFormat);
                uniqueFiles.put(file, csv);
                this.readCSV.add(csv);
            }
            this.csvMap.put(csvField, (ReadCSV)uniqueFiles.get(file));
        }
    }

    private void openDataSet() {
        this.readDataSet.clear();
        this.dataSetFieldMap.clear();
        this.dataSetIteratorMap.clear();
        HashMap<NeuralDataSet, MLDataFieldHolder> uniqueSets = new HashMap<NeuralDataSet, MLDataFieldHolder>();
        for (InputField field : this.inputFields) {
            if (!(field instanceof InputFieldMLDataSet)) continue;
            InputFieldMLDataSet dataSetField = (InputFieldMLDataSet)field;
            NeuralDataSet dataSet = dataSetField.getNeuralDataSet();
            if (!uniqueSets.containsKey(dataSet)) {
                Iterator<MLDataPair> iterator = dataSet.iterator();
                MLDataFieldHolder holder = new MLDataFieldHolder(iterator, dataSetField);
                uniqueSets.put(dataSet, holder);
                this.readDataSet.add(iterator);
            }
            MLDataFieldHolder holder = (MLDataFieldHolder)uniqueSets.get(dataSet);
            this.dataSetFieldMap.put(dataSetField, holder);
            this.dataSetIteratorMap.put(holder.getIterator(), holder);
        }
    }

    public void init() {
        this.readCSV = new ArrayList<ReadCSV>();
        this.csvMap = new HashMap<InputField, ReadCSV>();
        this.readDataSet = new ArrayList<Iterator<MLDataPair>>();
        this.dataSetFieldMap = new HashMap<InputField, MLDataFieldHolder>();
        this.dataSetIteratorMap = new HashMap<Iterator<MLDataPair>, MLDataFieldHolder>();
        if (this.report == null) {
            this.report = new NullStatusReportable();
        }
    }

    public void process() {
        this.init();
        if (this.twoPassesNeeded()) {
            this.firstPass();
        }
        this.secondPass();
    }

    private void reportResult(String message, int total, int current) {
        ++this.lastReport;
        if (this.lastReport >= 10000) {
            this.report.report(total, current, message);
            this.lastReport = 0;
        }
    }

    private void secondPass() {
        boolean twopass = this.twoPassesNeeded();
        this.openCSV();
        this.openDataSet();
        this.initForPass();
        this.currentIndex = -1;
        int size = this.getOutputFieldCount();
        double[] output = new double[size];
        if (this.storage == null) {
            throw new NormalizationError("Must define storage target.");
        }
        this.storage.open(this);
        this.lastReport = 0;
        int index = 0;
        int current = 0;
        while (this.next()) {
            for (InputField field : this.inputFields) {
                this.determineInputFieldValue(field, index);
            }
            if (this.shouldInclude()) {
                this.initForOutput();
                int outputIndex = 0;
                for (OutputField ofield : this.outputFields) {
                    for (int sub = 0; sub < ofield.getSubfieldCount(); ++sub) {
                        output[outputIndex++] = ofield.calculate(sub);
                    }
                }
                if (twopass) {
                    this.reportResult("Second pass, normalizing data", this.recordCount, ++current);
                } else {
                    this.reportResult("Processing data (single pass)", this.recordCount, ++current);
                }
                this.storage.write(output, 0);
            }
            ++index;
        }
        this.storage.close();
    }

    public void setCSVFormat(CSVFormat csvFormat) {
        this.csvFormat = csvFormat;
    }

    public void setReport(StatusReportable report) {
        this.report = report;
    }

    public void setTarget(NormalizationStorage target) {
        this.storage = target;
    }

    private boolean shouldInclude() {
        if (this.segregators.size() == 0) {
            return true;
        }
        boolean included = false;
        for (Segregator segregator : this.segregators) {
            if (!segregator.shouldInclude()) continue;
            included = true;
        }
        return included;
    }

    public boolean twoPassesNeeded() {
        for (OutputField field : this.outputFields) {
            if (!(field instanceof RequireTwoPass)) continue;
            return true;
        }
        return false;
    }
}

