/*
 * Copyright 2011 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea

import endea.internal.data._

import java.io._

object Data {

  private val dataDirectory = new File(Endea.path, "data")

  def node[D <: Data](path: String*)(implicit manifest: Manifest[D]): DataNode[D] = {

    val metaData = MetaData.get(manifest)
    val file = new File(dataDirectory + "/" + metaData.name + "/" + path.mkString("/"))

    new DataNode(file, metaData)
  }

  def tmpNode[D <: Data](implicit manifest: Manifest[D]) = {
    node("tmp", System.currentTimeMillis().toString())(manifest)
  }
}

trait Data {

}