/*
 * Copyright 2012 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.http

import endea._
import javax.servlet.http._

object HttpAction {
  val defaultAction = "default"
}

abstract class HttpAction[E <: Entity](
  implicit manifest: Manifest[E]) {

  val className = manifest.toString()

  def name = HttpAction.defaultAction

  def doGet(event: Event[E])

  def doPost(event: Event[E]) {

    val error =
      if (event.httpRequest.getProtocol().endsWith("1.1"))
        HttpServletResponse.SC_METHOD_NOT_ALLOWED
      else
        HttpServletResponse.SC_BAD_REQUEST

    val msg = "http method post not supported"

    event.httpResponse.sendError(error, msg)
  }
}