package endea.internal

import java.io._
import java.util._
import scala.collection.mutable._

class ByteArrayOutputStream extends OutputStream {

  private var buffer = new Array[Byte](32)
  private var count = 0

  override def write(byte: Int) {

    val newcount = count + 1
    if (newcount > buffer.length)
      buffer = Arrays.copyOf(buffer, buffer.length << 1)

    buffer(count) = byte.asInstanceOf[Byte]
    count = newcount
  }

  override def write(b: Array[Byte], off: Int, len: Int) {

    if ((off < 0) || (off > b.length) || (len < 0) ||
      ((off + len) > b.length) || ((off + len) < 0)) {
      throw new IndexOutOfBoundsException()
    } else if (len == 0) {
      return
    }

    val newcount = count + len
    if (newcount > buffer.length)
      buffer = Arrays.copyOf(buffer, scala.math.max(buffer.length << 1, newcount))
    System.arraycopy(b, off, buffer, count, len)
    count = newcount
  }

  def toByteArray(): Array[Byte] = {
    Arrays.copyOf(buffer, count)
  }

  def size(): Int = {
    count
  }
}