/*
 * Copyright 2011 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal

object DynamicClassLoader extends ClassLoader {

  val classLoader = ClassLoader.getSystemClassLoader()

  lazy val defineClass = {
    val method = Class.forName("java.lang.ClassLoader").getDeclaredMethod("defineClass",
      classOf[String], classOf[Array[Byte]], classOf[Int], classOf[Int])
    method.setAccessible(true)
    method
  }

  private def load(className: String, dump: Unit => Array[Byte]) = {

    try {
      loadClass(className)
    } catch {
      case e: ClassNotFoundException =>
        val bytes = dump()
        defineClass(className, bytes, 0, bytes.length)
    }
  }

  def loadClass(className: String, dump: Unit => Array[Byte]): Class[_] = {

    try {
      classLoader.loadClass(className)
    } catch {
      case e: ClassNotFoundException =>
        val classBytes = dump()
        defineClass.invoke(classLoader, className, classBytes,
          new java.lang.Integer(0),
          new java.lang.Integer(classBytes.length)).
          asInstanceOf[Class[_]]
    }
  }
}