/*
 * Copyright 2011 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.entity

import endea._
import com.sleepycat.je._
import scala.collection.Iterator

class EntityCursorImpl[E <: Entity](attribute: Int) extends EntityCursor[E] {

  private val jeCursor = EntityStore.getIndex(attribute).openCursor(null, null)

  //jeCursor.search()

  override def next(): Option[E] = {

    val key = new DatabaseEntry()
    val data = new DatabaseEntry()

    val status = jeCursor.getNext(key, data, null)
    if (status == OperationStatus.SUCCESS)
      EntityStore.get(Key.decodeLong(data.getData()))
    else
      None
  }

  override def close() {
    if (jeCursor != null)
      jeCursor.close
  }
}