/*
 * Copyright 2012 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.entity

import endea._
import com.sleepycat.je._

object Key {

  def encode(any: Any): Array[Byte] = any match {

    case entity: Entity => encodeLong(entity.id)
    case long: Long => encodeLong(long)
    case int: Int => encodeInt(int)
    case _ => throw new Exception("Not supported type: " + any)
  }

  def decodeLong(bytes: Array[Byte]): Long = {

    ((bytes(0) << 56) | (bytes(1) << 48) | (bytes(2) << 40) | (bytes(3) << 32) |
      (bytes(4) << 24) | (bytes(5) << 16) | (bytes(6) << 8) | bytes(7)) ^ 0x8000000000000000L
  }

  def encodeInt(_value: Int) = {

    val bytes = new Array[Byte](4)

    val value = _value ^ 0x80000000
    bytes(0) = (value >>> 24).asInstanceOf[Byte]
    bytes(1) = (value >>> 16).asInstanceOf[Byte]
    bytes(2) = (value >>> 8).asInstanceOf[Byte]
    bytes(3) = value.asInstanceOf[Byte]

    bytes
  }

  def encodeLong(_value: Long) = {

    val bytes = new Array[Byte](8)

    val value = _value ^ 0x8000000000000000L
    bytes(0) = (value >>> 56).asInstanceOf[Byte]
    bytes(1) = (value >>> 48).asInstanceOf[Byte]
    bytes(2) = (value >>> 40).asInstanceOf[Byte]
    bytes(3) = (value >>> 32).asInstanceOf[Byte]
    bytes(4) = (value >>> 24).asInstanceOf[Byte]
    bytes(5) = (value >>> 16).asInstanceOf[Byte]
    bytes(6) = (value >>> 8).asInstanceOf[Byte]
    bytes(7) = value.asInstanceOf[Byte]

    bytes
  }
}