/*
 * Copyright 2011 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.http

import endea._
import endea.http._

import org.eclipse.jetty.server.Server
import org.eclipse.jetty.servlet.ServletContextHandler
import org.eclipse.jetty.servlet.ServletHolder

import javax.servlet.http._
import javax.servlet.http.HttpServletRequest
import javax.servlet.http.HttpServletResponse

object HttpServer {

  private var server = new Server(8080)

  def start = {

    val context = new ServletContextHandler(ServletContextHandler.SESSIONS)
    context.setContextPath("/")
    server.setHandler(context)
    context.addServlet(new ServletHolder(new DefaultServlet()), "/*")

    server.start();
    server.join();
  }

  def stop() = server.stop()

  class DefaultServlet extends HttpServlet {

    override def doGet(request: HttpServletRequest, response: HttpServletResponse) {

      val session = new SessionImpl(request.getSession())
      val (entity, action) = Controller.decode(request.getRequestURI(), session)

      // TODO resolve types
      action.asInstanceOf[HttpAction[Entity]].doGet(new Event[Entity](entity, session, request, response))
    }

    override def doPost(request: HttpServletRequest, response: HttpServletResponse) {

      val session = new SessionImpl(request.getSession())
      val (entity, action) = Controller.decode(request.getRequestURI(), session)

      // TODO resolve types
      action.asInstanceOf[HttpAction[Entity]].doPost(new Event[Entity](entity, session, request, response))
    }
  }
}