/*
 * Copyright 2012 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.http

import endea._
import endea.http._

import javax.servlet.http._

class SessionImpl(private val httpSession: HttpSession) extends Session {

  def get[E <: Entity](key: String)(implicit manifest: Manifest[E]): Option[E] = {

    val entity = httpSession.getAttribute(key)
    if (entity != null && manifest.erasure.isAssignableFrom(entity.getClass()))
      Some(entity).asInstanceOf[Some[E]]
    else None
  }

  def put[E <: Entity](key: String, entity: E) {
    httpSession.setAttribute(key, entity)
  }

  def remove(key: String) {
    httpSession.removeAttribute(key)
  }
}