/*
 * Copyright 2011 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.value

class Date(val year: Int, val month: Int, val day: Int) {

  def +(hour: Int, min: Int) = {
    val calendar = new java.util.GregorianCalendar(year, month - 1, day, hour, min)
    new Time(calendar.getTimeInMillis())
  }

  def toString(separator: String) = {
    year + separator + month + separator + day
  }
}

/*
 * http://en.wikipedia.org/wiki/ISO_8601
 */
object Date {

  def Oct(day: Int, year: Int) = new Date(year, 10, day)
  def Nov(day: Int, year: Int) = new Date(year, 11, day)

  /*
   * http://en.wikipedia.org/wiki/Time_zone
   * http://en.wikipedia.org/wiki/List_of_time_zone_abbreviations
   */
  abstract class TimeZone(
    val code: String,
    val name: String) {
  }

  object CT extends TimeZone("CT", "Central Time (North America)")
  object ET extends TimeZone("ET", "Eastern Time (North America)")
  object PT extends TimeZone("PT", "Pacific Time (North America)")
}