/*
 * Copyright 2011 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea

import endea.internal._
import endea.internal.entity._

import scala.collection.mutable.ListBuffer

object Entity {

  def instance(bytes: Array[Byte]): Entity = Serial.instance(bytes)

  def get[E <: Entity](id: Long)(implicit manifest: Manifest[E]): Option[E] = {
    EntityStore.get(id)
  }

  def cursor[E <: Entity](implicit manifest: Manifest[E]): EntityCursor[E] = {

    MetaEntity.getByClassName(manifest.toString()) match {
      case Some(metaEntity) =>
        val filter = metaEntity.id // TODO +  get sub ids
        new EntityCursorImpl(EntityStore.class_attribute)
      case _ => throw new Exception("TODO: return empty cursor, ¿and log?")
    }
  }

  lazy val all = {

    val entities = new ListBuffer[Class[_ <: Entity]]

    val classLoader = classOf[Module].getClassLoader()
    for (
      module <- Module.modules;
      entity <- module.entities
    ) {
      try {
        // TODO test class is assignable Class[Entity]
        entities += classLoader.loadClass(entity).asInstanceOf[Class[_ <: Entity]]
      } catch {
        case e: ClassNotFoundException =>
          System.err.println(entity + " not found - " + module)
      }
    }

    entities
  }
}

abstract class Entity {

  val id: Long = 0

  final def bytes: Array[Byte] = Serial.bytes(this)

  def persist() {
    EntityStore.put(this)
  }

  override def equals(that: Any) = that match {
    case entity: Entity => id == entity.id
    case _ => false
  }

  override def hashCode() = id.toInt
}





