/*
 * Copyright 2011 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal

import endea._
import java.lang.reflect._

class Attribute(private val field: Field) {

  field.setAccessible(true)

  lazy val name = getName(field)

  val id = field.getAnnotation(classOf[Id]).value

  val indexed =
    {
      field.getType().isAssignableFrom(classOf[Entity])
    }

  val clazz = field.getType()

  def get(entity: Entity): Any = {
    field.get(entity)
  }

  def set(entity: Entity, value: Any) {
    field.set(entity, value)
  }

  override def toString: String = {
    field.toString()
  }

  private def getName(field: Field) = {

    val fieldName = field.getName
    fieldName(0).toUpper + fieldName.substring(1)
  }
}