/*
 * Copyright 2012 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.auth

import endea._

import endea.http._

import javax.servlet._
import org.brickred.socialauth._
import org.brickred.socialauth.util.SocialAuthUtil

object AuthAction extends HttpAction[Type[User]] {

  override val name = "auth"

  val session_name = AuthAction.getClass().getName

  def doGet(event: Event[Type[User]]) {

    val socialAuthManager = event.httpRequest.getAttribute(session_name).
      asInstanceOf[SocialAuthManager]

    if (socialAuthManager == null)
      OpenIdAction.doGet(event)
    else {
      val provider = socialAuthManager.connect(SocialAuthUtil.
        getRequestParametersMap(event.httpRequest))

      val profile = provider.getUserProfile()
      //      val id = new OAuthId(OAuthProvider.get(provider.getProviderId()),
      //        profile.getValidatedId())

      val user = new User(profile.getDisplayName())

      Auth.logIn(event, user)
    }
  }
}