/*
 * Copyright 2011 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.auth

import endea._
import endea.http._
import endea.html._
import endea.internal.http._

object SignInAction extends HtmlAction[Type[User]] {

  override val name = "sign-in"

  val css = Resource(SignInAction, "sign-in.css")
  val js = None

  private val url = Controller.encode(SignInAction)
  private val _id = "id"
  private val passwordKey = "password"

  override def doPost(event: Event[Type[User]]) {

    val option_user: Option[User] = event.parameter(passwordKey) match {
      case Some(password) =>
        event.parameter(_id) match {
          case Some(id) => findUser(id, password)
          case _ => None
        }
      case _ => None
    }

    option_user match {
      case Some(user) =>
        Auth.logIn(event, user)
      case None =>
        event.parameter(_id) match {
          case Some(id) => event.attribute(_id, id)
          case _ =>
        }
        doGet(event)
    }
  }

  def write(event: Event[Type[User]]) {

    event.write("""<div class="login">
<table class="panel">
<form action="""")
    event.write(url)
    event.write("""" method="post">
  <div style="display:none"><input type="hidden" name="csrfmiddlewaretoken" value="e80ece67b6d248a41193167bf86eb3c4"></div>
  <tr><td></td></tr>
  <tr><td class="label"><label for="id_username">Username or email</label></td></tr>
  <tr><td><input type="text" id="id_username" name="""")
    event.write(_id)
    event.attribute[String](_id) match {
      case Some(id) =>
        event.write("""" value="""")
        event.write(id)
      case _ =>
    }
    event.write("""" autofocus="autofocus"/></tr></td>
  <tr><td class="label"><label for="id_password">Password</label></td></tr>
  <tr><td><input type="password" id="id_password" name="""")
    event.write(passwordKey)
    event.write(""""/></tr></td>
  <tr><td><input type="submit" value="Log in" name="submit"/></tr></td>
</form>
</table>
 <!--p class="reset"><a href="/account/password/reset/" tabindex="-1">Reset password</a></p-->        
<!--br/><p>Need an account? <a href="">Sign up</a> now!</p-->
</div>""")
  }

  private def findUser(id: String, password: String) = {
    Some(new User(id))
  }
}