/*
 * Copyright 2011 David de Mingo <david@demingo.name>
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

package endea.internal.data

import endea._
import scala.collection.mutable.HashMap

object MetaData {

  private val map = new HashMap[String, MetaData[_]]()

  def get[D <: Data](clazz: Class[D]): MetaData[D] = {

    val manifest = Manifest.classType(clazz).asInstanceOf[Manifest[D]]
    get(manifest)
  }

  def get[D <: Data](implicit manifest: Manifest[D]): MetaData[D] = {

    map.getOrElseUpdate(manifest.toString(), {
      new MetaData(Class.forName(manifest.toString()).asInstanceOf[Class[D]])
    }).asInstanceOf[MetaData[D]]
  }
}

class MetaData[D <: Data] private (val clazz: Class[D]) {

  lazy val name = clazz.getSimpleName()

  lazy val fields = {

    val elements = for (
      field <- clazz.getDeclaredFields();
      annotation = field.getAnnotation(classOf[Id]);
      if (annotation != null)
    ) yield new Field(annotation.value(), field)

    elements.sortWith((e1, e2) => e1.id - e2.id < 0)
  }
}